"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const route53 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const certmgr = require("../lib");
class CertStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const hostedZone = route53.HostedZone.fromLookup(this, 'HostedZone', {
            domainName: 'example.com',
            privateZone: false
        });
        const certificate = new certmgr.DnsValidatedCertificate(this, 'TestCertificate', {
            domainName: 'test.example.com',
            hostedZone,
        });
        /// !hide
        Array.isArray(certificate);
    }
}
const app = new core_1.App();
new CertStack(app, 'MyStack4');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhhbXBsZS5kbnMtdmFsaWRhdGVkLXJlcXVlc3QubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXhhbXBsZS5kbnMtdmFsaWRhdGVkLXJlcXVlc3QubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsZ0RBQWlEO0FBQ2pELHdDQUFzRDtBQUN0RCxrQ0FBbUM7QUFFbkMsTUFBTSxTQUFVLFNBQVEsWUFBSztJQUMzQixZQUFZLEtBQWdCLEVBQUUsRUFBVTtRQUN0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLFNBQVM7UUFDVCxNQUFNLFVBQVUsR0FBRyxPQUFPLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFO1lBQ25FLFVBQVUsRUFBRSxhQUFhO1lBQ3pCLFdBQVcsRUFBRSxLQUFLO1NBQ25CLENBQUMsQ0FBQztRQUVILE1BQU0sV0FBVyxHQUFHLElBQUksT0FBTyxDQUFDLHVCQUF1QixDQUFDLElBQUksRUFBRSxpQkFBaUIsRUFBRTtZQUM3RSxVQUFVLEVBQUUsa0JBQWtCO1lBQzlCLFVBQVU7U0FDYixDQUFDLENBQUM7UUFDSCxTQUFTO1FBRVQsS0FBSyxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM3QixDQUFDO0NBQ0Y7QUFFRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQ3RCLElBQUksU0FBUyxDQUFDLEdBQUcsRUFBRSxVQUFVLENBQUMsQ0FBQztBQUMvQixHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgcm91dGU1MyA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2F3cy1yb3V0ZTUzJyk7XG5pbXBvcnQgeyBBcHAsIENvbnN0cnVjdCwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCBjZXJ0bWdyID0gcmVxdWlyZSgnLi4vbGliJyk7XG5cbmNsYXNzIENlcnRTdGFjayBleHRlbmRzIFN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgLy8vICFzaG93XG4gICAgY29uc3QgaG9zdGVkWm9uZSA9IHJvdXRlNTMuSG9zdGVkWm9uZS5mcm9tTG9va3VwKHRoaXMsICdIb3N0ZWRab25lJywge1xuICAgICAgZG9tYWluTmFtZTogJ2V4YW1wbGUuY29tJyxcbiAgICAgIHByaXZhdGVab25lOiBmYWxzZVxuICAgIH0pO1xuXG4gICAgY29uc3QgY2VydGlmaWNhdGUgPSBuZXcgY2VydG1nci5EbnNWYWxpZGF0ZWRDZXJ0aWZpY2F0ZSh0aGlzLCAnVGVzdENlcnRpZmljYXRlJywge1xuICAgICAgICBkb21haW5OYW1lOiAndGVzdC5leGFtcGxlLmNvbScsXG4gICAgICAgIGhvc3RlZFpvbmUsXG4gICAgfSk7XG4gICAgLy8vICFoaWRlXG5cbiAgICBBcnJheS5pc0FycmF5KGNlcnRpZmljYXRlKTtcbiAgfVxufVxuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5uZXcgQ2VydFN0YWNrKGFwcCwgJ015U3RhY2s0Jyk7XG5hcHAuc3ludGgoKTtcbiJdfQ==