"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'apex domain selection by default'(test) {
        const stack = new core_1.Stack();
        new lib_1.Certificate(stack, 'Certificate', {
            domainName: 'test.example.com'
        });
        assert_1.expect(stack).to(assert_1.haveResource('AWS::CertificateManager::Certificate', {
            DomainName: 'test.example.com',
            DomainValidationOptions: [{
                    DomainName: "test.example.com",
                    ValidationDomain: "example.com"
                }]
        }));
        test.done();
    },
    'validation domain can be overridden'(test) {
        const stack = new core_1.Stack();
        new lib_1.Certificate(stack, 'Certificate', {
            domainName: 'test.example.com',
            validationDomains: {
                'test.example.com': 'test.example.com'
            }
        });
        assert_1.expect(stack).to(assert_1.haveResource('AWS::CertificateManager::Certificate', {
            DomainValidationOptions: [{
                    DomainName: "test.example.com",
                    ValidationDomain: "test.example.com"
                }]
        }));
        test.done();
    },
    'export and import'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        const c = lib_1.Certificate.fromCertificateArn(stack, 'Imported', 'cert-arn');
        // THEN
        test.deepEqual(c.certificateArn, 'cert-arn');
        test.done();
    },
    'can configure validatin method'(test) {
        const stack = new core_1.Stack();
        new lib_1.Certificate(stack, 'Certificate', {
            domainName: 'test.example.com',
            validationMethod: lib_1.ValidationMethod.DNS
        });
        assert_1.expect(stack).to(assert_1.haveResource('AWS::CertificateManager::Certificate', {
            DomainName: 'test.example.com',
            ValidationMethod: 'DNS',
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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