# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

import warnings
from datetime import date, datetime
from json import dumps
from typing import Any, Dict, List, Optional, Tuple, Union
from urllib.parse import urlencode

from typing_extensions import Annotated


class AccountConnectionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, accounting) -> None:
        self.accounting = accounting

    def delete_account_connection(
        self, uuid: str, connection: str, **kwargs
    ) -> Any | None:
        """Delete an account's connection


        :param uuid: The account uuid (required)
        :type uuid: str
        :param connection: The connection uuid (required)
        :type connection: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/accounts/{uuid}/connect/{connection}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if connection is not None:
            path = path.replace("{" + "connection" + "}", connection)

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="DELETE", path=path, **kwargs)

    def list_account_connections(
        self,
        uuid: str,
        fields: str = None,
        page: str = None,
        per_page: str = None,
        **kwargs,
    ) -> Any | None:
        """List account's connections


        :param uuid: The account uuid (required)
        :type uuid: str
        :param fields: A comma separated list of fields requested in the response
        :type fields: str
        :param page: The response page
        :type page: str
        :param per_page: The number of items per page
        :type per_page: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/accounts/{uuid}/connect"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if fields is not None:

            query_params["fields"] = fields

        if page is not None:

            query_params["page"] = page

        if per_page is not None:

            query_params["per_page"] = per_page

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def list_banks(self, uuid: str, country: str = None, **kwargs) -> Any | None:
        """List available bank connections


        :param uuid: The account uuid (required)
        :type uuid: str
        :param country: A two letter country code, if none are specified, the company's country is used
        :type country: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/accounts/{uuid}/connect/banks"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if country is not None:

            query_params["country"] = country

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def list_connectable_bank_accounts(
        self, uuid: str, connection: str = None, **kwargs
    ) -> Any | None:
        """List connectable bank accounts


        :param uuid: The account uuid (required)
        :type uuid: str
        :param connection: The connection request UUID
        :type connection: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/accounts/{uuid}/connect/accounts"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if connection is not None:

            query_params["connection"] = connection

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def list_connected_account_transactions(
        self, uuid: str, connection: str, period: float = None, **kwargs
    ) -> Any | None:
        """List the connected account's transactions


        :param uuid: The account uuid (required)
        :type uuid: str
        :param connection: The connection uuid (required)
        :type connection: str
        :param period: The number of days to look back for transactions. Default is 7 days.
        :type period: float
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/accounts/{uuid}/connect/{connection}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if connection is not None:
            path = path.replace("{" + "connection" + "}", connection)
        if period is not None:

            query_params["period"] = period

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def request_bank_connection(
        self, uuid: str, request_bank_connection_request: dict, **kwargs
    ) -> Any | None:
        """Request a new bank connection


        :param uuid: The account uuid (required)
        :type uuid: str
        :param request_bank_connection_request: (required)
        :type request_bank_connection_request: RequestBankConnectionRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/accounts/{uuid}/connect/request"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if request_bank_connection_request is not None:
            kwargs["json"] = request_bank_connection_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="POST", path=path, **kwargs)

    def select_bank_account(
        self, uuid: str, select_bank_account_request: dict, **kwargs
    ) -> Any | None:
        """Select a bank account to connect


        :param uuid: The account uuid (required)
        :type uuid: str
        :param select_bank_account_request: (required)
        :type select_bank_account_request: SelectBankAccountRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/accounts/{uuid}/connect/accounts"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if select_bank_account_request is not None:
            kwargs["json"] = select_bank_account_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="POST", path=path, **kwargs)
