# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

import warnings
from datetime import date, datetime
from json import dumps
from typing import Any, Dict, List, Optional, Tuple, Union
from urllib.parse import urlencode

from typing_extensions import Annotated


class ExpenseReportsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, accounting) -> None:
        self.accounting = accounting

    def add_expense_report(
        self, add_expense_report_request: dict, **kwargs
    ) -> Any | None:
        """Add an expense report


        :param add_expense_report_request: (required)
        :type add_expense_report_request: AddExpenseReportRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if add_expense_report_request is not None:
            kwargs["json"] = add_expense_report_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="POST", path=path, **kwargs)

    def delete_expense_report(self, uuid: str, **kwargs) -> Any | None:
        """Delete an expense report


        :param uuid: The expense report uuid (required)
        :type uuid: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports/{uuid}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="DELETE", path=path, **kwargs)

    def expense_report_o_auth_login(self, method: str, **kwargs) -> Any | None:
        """OAuth Login


        :param method: The OAuth Provider to use (required)
        :type method: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports/login/{method}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if method is not None:
            path = path.replace("{" + "method" + "}", method)

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def get_expense_report(self, uuid: str, **kwargs) -> Any | None:
        """Get an expense report


        :param uuid: The expense report uuid (required)
        :type uuid: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports/{uuid}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def get_expense_report_account(self, **kwargs) -> Any | None:
        """Get the currently connected expense report user details


        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports/me"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def get_expense_report_user(self, uuid: str, **kwargs) -> Any | None:
        """Get an user details


        :param uuid: The expense report user uuid (required)
        :type uuid: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports/users/{uuid}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def list_expense_reports(
        self, fields: str = None, page: str = None, per_page: str = None, **kwargs
    ) -> Any | None:
        """List company's expense reports.

        List company's expense reports. If the token used has the `expense_report.limited_to_self` permission, this will only list the user's expense reports

        :param fields: A comma separated list of fields requested in the response
        :type fields: str
        :param page: The response page
        :type page: str
        :param per_page: The number of items per page
        :type per_page: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if fields is not None:

            query_params["fields"] = fields

        if page is not None:

            query_params["page"] = page

        if per_page is not None:

            query_params["per_page"] = per_page

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def send_expense_report_login_email(
        self, send_expense_report_login_email_request: dict, **kwargs
    ) -> Any | None:
        """Request login email


        :param send_expense_report_login_email_request: (required)
        :type send_expense_report_login_email_request: SendExpenseReportLoginEmailRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports/login"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if send_expense_report_login_email_request is not None:
            kwargs["json"] = send_expense_report_login_email_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="POST", path=path, **kwargs)

    def update_expense_report(
        self, uuid: str, add_expense_report_request: dict, **kwargs
    ) -> Any | None:
        """Update an expense report


        :param uuid: The expense report uuid (required)
        :type uuid: str
        :param add_expense_report_request: (required)
        :type add_expense_report_request: AddExpenseReportRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports/{uuid}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if add_expense_report_request is not None:
            kwargs["json"] = add_expense_report_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="PUT", path=path, **kwargs)

    def update_expense_report_account(
        self, update_expense_report_account_request: dict, **kwargs
    ) -> Any | None:
        """Update the currently connected expense report user


        :param update_expense_report_account_request: (required)
        :type update_expense_report_account_request: UpdateExpenseReportAccountRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports/me"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if update_expense_report_account_request is not None:
            kwargs["json"] = update_expense_report_account_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="PUT", path=path, **kwargs)

    def update_expense_report_settings(
        self, update_expense_report_settings_request: dict, **kwargs
    ) -> Any | None:
        """Retrieve company settings for expense reports

        At least an url or a company must be provided

        :param update_expense_report_settings_request: (required)
        :type update_expense_report_settings_request: UpdateExpenseReportSettingsRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports/settings"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if update_expense_report_settings_request is not None:
            kwargs["json"] = update_expense_report_settings_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="POST", path=path, **kwargs)

    def verify_expense_report_settings(
        self, verify_expense_report_settings_request: dict, **kwargs
    ) -> Any | None:
        """Verify expense reports settings


        :param verify_expense_report_settings_request: (required)
        :type verify_expense_report_settings_request: VerifyExpenseReportSettingsRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/expenses/expense-reports/verify"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if verify_expense_report_settings_request is not None:
            kwargs["json"] = verify_expense_report_settings_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="POST", path=path, **kwargs)
