# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

import warnings
from datetime import date, datetime
from json import dumps
from typing import Any, Dict, List, Optional, Tuple, Union
from urllib.parse import urlencode

from typing_extensions import Annotated


class LogsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, accounting) -> None:
        self.accounting = accounting

    def logs(
        self,
        fields: str = None,
        page: str = None,
        per_page: str = None,
        channel: str = None,
        level: str = None,
        resource: str = None,
        before: str = None,
        after: str = None,
        format: str = None,
        **kwargs,
    ) -> Any | None:
        """List company's logs


        :param fields: A comma separated list of fields requested in the response
        :type fields: str
        :param page: The response page
        :type page: str
        :param per_page: The number of items per page
        :type per_page: str
        :param channel: The channel to retrieve the logs from
        :type channel: str
        :param level: The log level to retrieve
        :type level: str
        :param resource: Retrive logs linked to that resource
        :type resource: str
        :param before: Retrive logs before the provided date
        :type before: str
        :param after: Retrive logs after the provided date
        :type after: str
        :param format: In which format to retrieve the logs, available: json or txt
        :type format: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/logs"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if fields is not None:

            query_params["fields"] = fields

        if page is not None:

            query_params["page"] = page

        if per_page is not None:

            query_params["per_page"] = per_page

        if channel is not None:

            query_params["channel"] = channel

        if level is not None:

            query_params["level"] = level

        if resource is not None:

            query_params["resource"] = resource

        if before is not None:

            query_params["before"] = before

        if after is not None:

            query_params["after"] = after

        if format is not None:

            query_params["format"] = format

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)
