# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

import warnings
from datetime import date, datetime
from json import dumps
from typing import Any, Dict, List, Optional, Tuple, Union
from urllib.parse import urlencode

from typing_extensions import Annotated


class TransactionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, accounting) -> None:
        self.accounting = accounting

    def add_link(
        self, list_links200_response_links_inner: dict, uuid: str = None, **kwargs
    ) -> Any | None:
        """Add a new transaction link


        :param list_links200_response_links_inner: (required)
        :type list_links200_response_links_inner: ListLinks200ResponseLinksInner
        :param uuid: A transaction uuid
        :type uuid: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}/links"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if list_links200_response_links_inner is not None:
            kwargs["json"] = list_links200_response_links_inner

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="POST", path=path, **kwargs)

    def add_transaction(self, add_transaction_request: dict, **kwargs) -> Any | None:
        """Add a transaction


        :param add_transaction_request: (required)
        :type add_transaction_request: AddTransactionRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if add_transaction_request is not None:
            kwargs["json"] = add_transaction_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="POST", path=path, **kwargs)

    def add_transaction_code(
        self, uuid: str, update_transaction_code_request: dict, **kwargs
    ) -> Any | None:
        """Add a transaction's code


        :param uuid: The transaction uuid (required)
        :type uuid: str
        :param update_transaction_code_request: (required)
        :type update_transaction_code_request: UpdateTransactionCodeRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}/codes"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if update_transaction_code_request is not None:
            kwargs["json"] = update_transaction_code_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="POST", path=path, **kwargs)

    def delete_link(
        self, uuid: str = None, link_uuid: str = None, **kwargs
    ) -> Any | None:
        """Delete a transaction link


        :param uuid: A transaction uuid
        :type uuid: str
        :param link_uuid: A transaction link uuid OR the target uuid
        :type link_uuid: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}/links/{link_uuid}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if link_uuid is not None:
            path = path.replace("{" + "link_uuid" + "}", link_uuid)

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="DELETE", path=path, **kwargs)

    def delete_transaction(self, uuid: str, **kwargs) -> Any | None:
        """Delete a transaction


        :param uuid: The transaction uuid (required)
        :type uuid: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="DELETE", path=path, **kwargs)

    def delete_transaction_code(self, uuid: str, code: str, **kwargs) -> Any | None:
        """Delete a transaction's code


        :param uuid: The transaction uuid (required)
        :type uuid: str
        :param code: The transaction's code uuid (required)
        :type code: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}/codes/{code}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if code is not None:
            path = path.replace("{" + "code" + "}", code)

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="DELETE", path=path, **kwargs)

    def get_transaction(self, uuid: str, **kwargs) -> Any | None:
        """Get a transaction


        :param uuid: The transaction uuid (required)
        :type uuid: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def import_transactions(
        self, import_transactions_request: dict, **kwargs
    ) -> Any | None:
        """Import transactions - INTERNAL

        Import transaction from a file or directly from extracted details

        :param import_transactions_request: (required)
        :type import_transactions_request: ImportTransactionsRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/import"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if import_transactions_request is not None:
            kwargs["json"] = import_transactions_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="POST", path=path, **kwargs)

    def ledger(
        self,
        fields: str = None,
        page: str = None,
        per_page: str = None,
        account: str = None,
        **kwargs,
    ) -> Any | None:
        """List company's transactions and transfers


        :param fields: A comma separated list of fields requested in the response
        :type fields: str
        :param page: The response page
        :type page: str
        :param per_page: The number of items per page
        :type per_page: str
        :param account: An account uuid to filter results
        :type account: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/ledger"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if fields is not None:

            query_params["fields"] = fields

        if page is not None:

            query_params["page"] = page

        if per_page is not None:

            query_params["per_page"] = per_page

        if account is not None:

            query_params["account"] = account

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def list_links(
        self,
        fields: str = None,
        page: str = None,
        per_page: str = None,
        uuid: str = None,
        **kwargs,
    ) -> Any | None:
        """List a transaction links


        :param fields: A comma separated list of fields requested in the response
        :type fields: str
        :param page: The response page
        :type page: str
        :param per_page: The number of items per page
        :type per_page: str
        :param uuid: A transaction uuid
        :type uuid: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}/links"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if fields is not None:

            query_params["fields"] = fields

        if page is not None:

            query_params["page"] = page

        if per_page is not None:

            query_params["per_page"] = per_page

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def list_transaction_codes(
        self,
        uuid: str,
        fields: str = None,
        page: str = None,
        per_page: str = None,
        account: str = None,
        **kwargs,
    ) -> Any | None:
        """List transaction's codes


        :param uuid: The transaction uuid (required)
        :type uuid: str
        :param fields: A comma separated list of fields requested in the response
        :type fields: str
        :param page: The response page
        :type page: str
        :param per_page: The number of items per page
        :type per_page: str
        :param account: List to the specified account
        :type account: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}/codes"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if fields is not None:

            query_params["fields"] = fields

        if page is not None:

            query_params["page"] = page

        if per_page is not None:

            query_params["per_page"] = per_page

        if account is not None:

            query_params["account"] = account

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def list_transactions(
        self,
        fields: str = None,
        page: str = None,
        per_page: str = None,
        account: str = None,
        **kwargs,
    ) -> Any | None:
        """List company's transactions


        :param fields: A comma separated list of fields requested in the response
        :type fields: str
        :param page: The response page
        :type page: str
        :param per_page: The number of items per page
        :type per_page: str
        :param account: List to the specified account
        :type account: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if fields is not None:

            query_params["fields"] = fields

        if page is not None:

            query_params["page"] = page

        if per_page is not None:

            query_params["per_page"] = per_page

        if account is not None:

            query_params["account"] = account

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)

    def update_link(
        self,
        list_links200_response_links_inner: dict,
        uuid: str = None,
        link_uuid: str = None,
        **kwargs,
    ) -> Any | None:
        """Update a transaction link


        :param list_links200_response_links_inner: (required)
        :type list_links200_response_links_inner: ListLinks200ResponseLinksInner
        :param uuid: A transaction uuid
        :type uuid: str
        :param link_uuid: A transaction link uuid OR the target uuid
        :type link_uuid: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}/links/{link_uuid}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if link_uuid is not None:
            path = path.replace("{" + "link_uuid" + "}", link_uuid)
        if list_links200_response_links_inner is not None:
            kwargs["json"] = list_links200_response_links_inner

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="PUT", path=path, **kwargs)

    def update_transaction(
        self, uuid: str, add_transaction_request: dict, **kwargs
    ) -> Any | None:
        """Update a transaction


        :param uuid: The transaction uuid (required)
        :type uuid: str
        :param add_transaction_request: (required)
        :type add_transaction_request: AddTransactionRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if add_transaction_request is not None:
            kwargs["json"] = add_transaction_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="PUT", path=path, **kwargs)

    def update_transaction_code(
        self, uuid: str, update_transaction_code_request: dict, **kwargs
    ) -> Any | None:
        """Update a transaction's code


        :param uuid: The transaction uuid (required)
        :type uuid: str
        :param update_transaction_code_request: (required)
        :type update_transaction_code_request: UpdateTransactionCodeRequest
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}/codes"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if update_transaction_code_request is not None:
            kwargs["json"] = update_transaction_code_request

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="PUT", path=path, **kwargs)

    def view_link(
        self, uuid: str = None, link_uuid: str = None, **kwargs
    ) -> Any | None:
        """View a transaction link


        :param uuid: A transaction uuid
        :type uuid: str
        :param link_uuid: A transaction link uuid OR the target uuid
        :type link_uuid: str
        :return: Returns a dict containing the API Response.
        """  # noqa: E501

        path = "/transactions/{uuid}/links/{link_uuid}"
        query_params = {}
        kwargs = kwargs | {"files": {}, "data": {}, "json": {}}

        if uuid is not None:
            path = path.replace("{" + "uuid" + "}", uuid)
        if link_uuid is not None:
            path = path.replace("{" + "link_uuid" + "}", link_uuid)

        if len(kwargs["data"]) == 0:
            del kwargs["data"]
        if len(kwargs["json"]) == 0:
            del kwargs["json"]
        if len(kwargs["files"]) == 0:
            del kwargs["files"]

        if len(query_params) > 0:
            query_params.update(
                {
                    k: dumps(v)
                    for k, v in query_params.items()
                    if isinstance(v, (bool, dict))
                }
            )
            path = path + "?" + urlencode(query_params, doseq=True)
        return self.accounting.request(method="GET", path=path, **kwargs)
