# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import unittest
from urllib.parse import urljoin

import requests_mock

from accounting_sh.accounting import Accounting
from accounting_sh.api.account_connections_api import AccountConnectionsApi


class TestAccountConnectionsApi(unittest.TestCase):
    """AccountConnectionsApi unit test stubs"""

    """
    def setUp(self) -> None:
        accounting = Accounting("fake-token")
        self.api = accounting.account_connections_api

    def tearDown(self) -> None:
        pass
    """

    @requests_mock.Mocker()
    def test_delete_account_connection(self, m) -> None:
        """Test case for delete_account_connection

        Delete an account's connection
        """
        path = urljoin(
            "https://api.accounting.sh", "/accounts/{uuid}/connect/{connection}"
        )
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        path = path.replace("{" + "connection" + "}", "connection_example")
        m.request("DELETE", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.account_connections_api.delete_account_connection(
                "uuid_example",
                "connection_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_account_connections(self, m) -> None:
        """Test case for list_account_connections

        List account's connections
        """
        path = urljoin("https://api.accounting.sh", "/accounts/{uuid}/connect")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.account_connections_api.list_account_connections(
                "uuid_example",
                "fields_example",
                "page_example",
                "per_page_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_banks(self, m) -> None:
        """Test case for list_banks

        List available bank connections
        """
        path = urljoin("https://api.accounting.sh", "/accounts/{uuid}/connect/banks")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.account_connections_api.list_banks(
                "uuid_example",
                "country_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_connectable_bank_accounts(self, m) -> None:
        """Test case for list_connectable_bank_accounts

        List connectable bank accounts
        """
        path = urljoin("https://api.accounting.sh", "/accounts/{uuid}/connect/accounts")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.account_connections_api.list_connectable_bank_accounts(
                "uuid_example",
                "connection_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_connected_account_transactions(self, m) -> None:
        """Test case for list_connected_account_transactions

        List the connected account's transactions
        """
        path = urljoin(
            "https://api.accounting.sh", "/accounts/{uuid}/connect/{connection}"
        )
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        path = path.replace("{" + "connection" + "}", "connection_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.account_connections_api.list_connected_account_transactions(
                "uuid_example",
                "connection_example",
                3.4,
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_request_bank_connection(self, m) -> None:
        """Test case for request_bank_connection

        Request a new bank connection
        """
        path = urljoin("https://api.accounting.sh", "/accounts/{uuid}/connect/request")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.account_connections_api.request_bank_connection(
                "uuid_example",
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_select_bank_account(self, m) -> None:
        """Test case for select_bank_account

        Select a bank account to connect
        """
        path = urljoin("https://api.accounting.sh", "/accounts/{uuid}/connect/accounts")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.account_connections_api.select_bank_account(
                "uuid_example",
                {},
            )
            is not None
        )


if __name__ == "__main__":
    unittest.main()
