# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import unittest
from urllib.parse import urljoin

import requests_mock

from accounting_sh.accounting import Accounting
from accounting_sh.api.auth_api import AuthApi


class TestAuthApi(unittest.TestCase):
    """AuthApi unit test stubs"""

    """
    def setUp(self) -> None:
        accounting = Accounting("fake-token")
        self.api = accounting.auth_api

    def tearDown(self) -> None:
        pass
    """

    @requests_mock.Mocker()
    def test_auth_init(self, m) -> None:
        """Test case for auth_init

        Init authentication process
        """
        path = urljoin("https://api.accounting.sh", "/auth/init")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert accounting.auth_api.auth_init() is not None

    @requests_mock.Mocker()
    def test_login(self, m) -> None:
        """Test case for login

        Login user
        """
        path = urljoin("https://api.accounting.sh", "/auth/login")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.auth_api.login(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_logout(self, m) -> None:
        """Test case for logout

        Logout current user
        """
        path = urljoin("https://api.accounting.sh", "/auth/logout")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert accounting.auth_api.logout() is not None

    @requests_mock.Mocker()
    def test_switch_company(self, m) -> None:
        """Test case for switch_company

        Switch to a different company
        """
        path = urljoin("https://api.accounting.sh", "/auth/switch")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.auth_api.switch_company(
                {},
            )
            is not None
        )


if __name__ == "__main__":
    unittest.main()
