# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import unittest
from urllib.parse import urljoin

import requests_mock

from accounting_sh.accounting import Accounting
from accounting_sh.api.bills_api import BillsApi


class TestBillsApi(unittest.TestCase):
    """BillsApi unit test stubs"""

    """
    def setUp(self) -> None:
        accounting = Accounting("fake-token")
        self.api = accounting.bills_api

    def tearDown(self) -> None:
        pass
    """

    @requests_mock.Mocker()
    def test_add_bill(self, m) -> None:
        """Test case for add_bill

        Add a bill
        """
        path = urljoin("https://api.accounting.sh", "/expenses/bills")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.bills_api.add_bill(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_add_bill_payment(self, m) -> None:
        """Test case for add_bill_payment

        Add a bill payment
        """
        path = urljoin("https://api.accounting.sh", "/expenses/bills/{uuid}/payments")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.bills_api.add_bill_payment(
                "uuid_example",
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_delete_bill(self, m) -> None:
        """Test case for delete_bill

        Delete a bill
        """
        path = urljoin("https://api.accounting.sh", "/expenses/bills/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("DELETE", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.bills_api.delete_bill(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_bill(self, m) -> None:
        """Test case for get_bill

        Get a bill
        """
        path = urljoin("https://api.accounting.sh", "/expenses/bills/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.bills_api.get_bill(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_bill_document(self, m) -> None:
        """Test case for get_bill_document

        Get a bill in PDF
        """
        path = urljoin("https://api.accounting.sh", "/expenses/bills/{uuid}/document")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.bills_api.get_bill_document(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_bills(self, m) -> None:
        """Test case for list_bills

        List company's bills
        """
        path = urljoin("https://api.accounting.sh", "/expenses/bills")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.bills_api.list_bills(
                "fields_example",
                "page_example",
                "per_page_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_bill(self, m) -> None:
        """Test case for update_bill

        Update a bill
        """
        path = urljoin("https://api.accounting.sh", "/expenses/bills/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.bills_api.update_bill(
                "uuid_example",
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_bill_payment(self, m) -> None:
        """Test case for update_bill_payment

        Update a bill payment
        """
        path = urljoin(
            "https://api.accounting.sh", "/expenses/bills/{uuid}/payments/{payment}"
        )
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        path = path.replace("{" + "payment" + "}", "payment_example")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.bills_api.update_bill_payment(
                "uuid_example",
                "payment_example",
                {},
            )
            is not None
        )


if __name__ == "__main__":
    unittest.main()
