# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import unittest
from urllib.parse import urljoin

import requests_mock

from accounting_sh.accounting import Accounting
from accounting_sh.api.expense_reports_api import ExpenseReportsApi


class TestExpenseReportsApi(unittest.TestCase):
    """ExpenseReportsApi unit test stubs"""

    """
    def setUp(self) -> None:
        accounting = Accounting("fake-token")
        self.api = accounting.expense_reports_api

    def tearDown(self) -> None:
        pass
    """

    @requests_mock.Mocker()
    def test_add_expense_report(self, m) -> None:
        """Test case for add_expense_report

        Add an expense report
        """
        path = urljoin("https://api.accounting.sh", "/expenses/expense-reports")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.add_expense_report(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_delete_expense_report(self, m) -> None:
        """Test case for delete_expense_report

        Delete an expense report
        """
        path = urljoin("https://api.accounting.sh", "/expenses/expense-reports/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("DELETE", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.delete_expense_report(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_expense_report_o_auth_login(self, m) -> None:
        """Test case for expense_report_o_auth_login

        OAuth Login
        """
        path = urljoin(
            "https://api.accounting.sh", "/expenses/expense-reports/login/{method}"
        )
        path = path.replace("{" + "method" + "}", "method_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.expense_report_o_auth_login(
                "method_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_expense_report(self, m) -> None:
        """Test case for get_expense_report

        Get an expense report
        """
        path = urljoin("https://api.accounting.sh", "/expenses/expense-reports/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.get_expense_report(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_expense_report_account(self, m) -> None:
        """Test case for get_expense_report_account

        Get the currently connected expense report user details
        """
        path = urljoin("https://api.accounting.sh", "/expenses/expense-reports/me")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert accounting.expense_reports_api.get_expense_report_account() is not None

    @requests_mock.Mocker()
    def test_get_expense_report_user(self, m) -> None:
        """Test case for get_expense_report_user

        Get an user details
        """
        path = urljoin(
            "https://api.accounting.sh", "/expenses/expense-reports/users/{uuid}"
        )
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.get_expense_report_user(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_expense_reports(self, m) -> None:
        """Test case for list_expense_reports

        List company's expense reports.
        """
        path = urljoin("https://api.accounting.sh", "/expenses/expense-reports")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.list_expense_reports(
                "fields_example",
                "page_example",
                "per_page_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_send_expense_report_login_email(self, m) -> None:
        """Test case for send_expense_report_login_email

        Request login email
        """
        path = urljoin("https://api.accounting.sh", "/expenses/expense-reports/login")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.send_expense_report_login_email(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_expense_report(self, m) -> None:
        """Test case for update_expense_report

        Update an expense report
        """
        path = urljoin("https://api.accounting.sh", "/expenses/expense-reports/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.update_expense_report(
                "uuid_example",
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_expense_report_account(self, m) -> None:
        """Test case for update_expense_report_account

        Update the currently connected expense report user
        """
        path = urljoin("https://api.accounting.sh", "/expenses/expense-reports/me")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.update_expense_report_account(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_expense_report_settings(self, m) -> None:
        """Test case for update_expense_report_settings

        Retrieve company settings for expense reports
        """
        path = urljoin(
            "https://api.accounting.sh", "/expenses/expense-reports/settings"
        )
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.update_expense_report_settings(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_verify_expense_report_settings(self, m) -> None:
        """Test case for verify_expense_report_settings

        Verify expense reports settings
        """
        path = urljoin("https://api.accounting.sh", "/expenses/expense-reports/verify")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.expense_reports_api.verify_expense_report_settings(
                {},
            )
            is not None
        )


if __name__ == "__main__":
    unittest.main()
