# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import unittest
from urllib.parse import urljoin

import requests_mock

from accounting_sh.accounting import Accounting
from accounting_sh.api.revenues_api import RevenuesApi


class TestRevenuesApi(unittest.TestCase):
    """RevenuesApi unit test stubs"""

    """
    def setUp(self) -> None:
        accounting = Accounting("fake-token")
        self.api = accounting.revenues_api

    def tearDown(self) -> None:
        pass
    """

    @requests_mock.Mocker()
    def test_add_revenue(self, m) -> None:
        """Test case for add_revenue

        Add a revenue
        """
        path = urljoin("https://api.accounting.sh", "/incomes/revenues")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.revenues_api.add_revenue(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_delete_revenue(self, m) -> None:
        """Test case for delete_revenue

        Delete a revenue
        """
        path = urljoin("https://api.accounting.sh", "/incomes/revenues/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("DELETE", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.revenues_api.delete_revenue(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_revenue(self, m) -> None:
        """Test case for get_revenue

        Get a revenue
        """
        path = urljoin("https://api.accounting.sh", "/incomes/revenues/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.revenues_api.get_revenue(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_revenues(self, m) -> None:
        """Test case for list_revenues

        List company's revenues
        """
        path = urljoin("https://api.accounting.sh", "/incomes/revenues")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.revenues_api.list_revenues(
                "fields_example",
                "page_example",
                "per_page_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_revenue(self, m) -> None:
        """Test case for update_revenue

        Update a revenue
        """
        path = urljoin("https://api.accounting.sh", "/incomes/revenues/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.revenues_api.update_revenue(
                "uuid_example",
                {},
            )
            is not None
        )


if __name__ == "__main__":
    unittest.main()
