# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import unittest
from urllib.parse import urljoin

import requests_mock

from accounting_sh.accounting import Accounting
from accounting_sh.api.tags_api import TagsApi


class TestTagsApi(unittest.TestCase):
    """TagsApi unit test stubs"""

    """
    def setUp(self) -> None:
        accounting = Accounting("fake-token")
        self.api = accounting.tags_api

    def tearDown(self) -> None:
        pass
    """

    @requests_mock.Mocker()
    def test_add_tag(self, m) -> None:
        """Test case for add_tag

        Add a tag
        """
        path = urljoin("https://api.accounting.sh", "/tags")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.tags_api.add_tag(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_delete_tag(self, m) -> None:
        """Test case for delete_tag

        Delete a tag
        """
        path = urljoin("https://api.accounting.sh", "/tags/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("DELETE", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.tags_api.delete_tag(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_tag(self, m) -> None:
        """Test case for get_tag

        Get a tag
        """
        path = urljoin("https://api.accounting.sh", "/tags/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.tags_api.get_tag(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_tags(self, m) -> None:
        """Test case for list_tags

        List company's tags
        """
        path = urljoin("https://api.accounting.sh", "/tags")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.tags_api.list_tags(
                "fields_example",
                "page_example",
                "per_page_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_tags_by_resource(self, m) -> None:
        """Test case for list_tags_by_resource

        List company's tags by resource attachment
        """
        path = urljoin("https://api.accounting.sh", "/tags/attachments/{resource}")
        path = path.replace("{" + "resource" + "}", "resource_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.tags_api.list_tags_by_resource(
                "resource_example",
                "fields_example",
                "page_example",
                "per_page_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_tag(self, m) -> None:
        """Test case for update_tag

        Update a tag
        """
        path = urljoin("https://api.accounting.sh", "/tags/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.tags_api.update_tag(
                "uuid_example",
                {},
            )
            is not None
        )


if __name__ == "__main__":
    unittest.main()
