# coding: utf-8

"""
Accounting API


The version of the OpenAPI document: 8.3.9
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


import unittest
from urllib.parse import urljoin

import requests_mock

from accounting_sh.accounting import Accounting
from accounting_sh.api.users_api import UsersApi


class TestUsersApi(unittest.TestCase):
    """UsersApi unit test stubs"""

    """
    def setUp(self) -> None:
        accounting = Accounting("fake-token")
        self.api = accounting.users_api

    def tearDown(self) -> None:
        pass
    """

    @requests_mock.Mocker()
    def test_add_user(self, m) -> None:
        """Test case for add_user

        Add user
        """
        path = urljoin("https://api.accounting.sh", "/users")
        m.request("POST", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.users_api.add_user(
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_delete_user(self, m) -> None:
        """Test case for delete_user

        Delete user
        """
        path = urljoin("https://api.accounting.sh", "/users/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("DELETE", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.users_api.delete_user(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_get_user(self, m) -> None:
        """Test case for get_user

        View user
        """
        path = urljoin("https://api.accounting.sh", "/users/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.users_api.get_user(
                "uuid_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_list_users(self, m) -> None:
        """Test case for list_users

        List company's users
        """
        path = urljoin("https://api.accounting.sh", "/users")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.users_api.list_users(
                "fields_example",
                "page_example",
                "per_page_example",
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_update_user(self, m) -> None:
        """Test case for update_user

        Update user
        """
        path = urljoin("https://api.accounting.sh", "/users/{uuid}")
        path = path.replace("{" + "uuid" + "}", "uuid_example")
        m.request("PUT", path)
        accounting = Accounting("fake-token")
        assert (
            accounting.users_api.update_user(
                "uuid_example",
                {},
            )
            is not None
        )

    @requests_mock.Mocker()
    def test_users_companies(self, m) -> None:
        """Test case for users_companies

        List current user companies
        """
        path = urljoin("https://api.accounting.sh", "/users/me/companies")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert accounting.users_api.users_companies() is not None

    @requests_mock.Mocker()
    def test_users_me(self, m) -> None:
        """Test case for users_me

        View current user details
        """
        path = urljoin("https://api.accounting.sh", "/users/me")
        m.request("GET", path)
        accounting = Accounting("fake-token")
        assert accounting.users_api.users_me() is not None


if __name__ == "__main__":
    unittest.main()
