# CSST-IFS ETC

## Description

Exposure time calculator for CSST-IFS. The Python module is 
constructed by modifing the JWST ETC (Pandeia), which would be
easily imported into Python programs.


## Installation
via pip:

    pip install ifs_etc


## Usage

* Creating a default configuration dictionaray:
        
    ```
    from ifs_etc.etc1d.config import build_default_calc
    config = build_default_calc()
    ```

 
* Editing the configuration:

    ```
    # changing the spectrum of the source  
    config['source']['spectrum']['name'] = 'SFgal_texp_FeH0_tau5_Ew10_AGN1.fits'
    
    # changing the surface brightness of the source
    config['source']['normalization']['value'] = 17.7
    ```



* Running the code:

    ```
    from ifs_etc.etc1d.perform_calculation import perform_calculation
    report = perform_calculation(calculation)
    ```  
        

* The output results:

    - `report.__dict__` lists all the information in the result
    - `report.snr` contains the signal-to-noise ratio generated by the calculation
    - `report.readnoise`, `report.darknoise`, `report.sourcenoise` contain
    different types of noise.
    - `report.mockwave`, `report.mockflux`, `report.mockerror` provide 
    the mock spectrum of the observation




## Examples

* S/N ratio reached in a exposure time of 900 seconds for 
an extended source with sdss g-band surface brightness of 18 
mag/arcsec<sup>2</sup> and AGN spectrum

    ```
    from ifs_etc.etc1d.config import build_default_calc
    from ifs_etc.etc1d.perform_calculation import perform_calculation

    config = build_default_calc()
    config['obst'] = 300
    config['repn'] = 3
    config['source']['normalization']['value'] = 18.0
    config['source']['spectrum']['name'] = 'SFgal_texp_FeH0_tau5_Ew10_AGN1.fits'
    report = perform_calculation(config)
    print(report.snr)
    ```
 
* Exposure time needed to obtain a S/N ratio of 10 for an elliptical galaxy 
with SDSS r-band surface brightness of 18 mag/arcsec<sup>2</sup>
 
     ```
    from ifs_etc.etc1d.config import build_default_calc
    from ifs_etc.etc1d.perform_calculation import perform_calculation
    
    config = build_default_calc()
    config['targetsnr'] = 10
    config['obst'] = 300
    config['source']['normalization']['value'] = 18.0
    config['source']['spectrum']['name'] = 'SFgal_texp_FeH0_tau1_Ewd.fits'
    report = perform_calculation(config, calculation_mode='snr2exptime')
    print(report.exptime)
     ```

## Acknowledgement

This project is supported by the CSST scientific data processing and analysis 
system of the China Manned Space Project and Shanghai Academic/Technology Research Leader (22XD1404200).


## Reference

* [JWST ETC Pandeia](https://jwst-docs.stsci.edu/jwst-exposure-time-calculator-overview/jwst-etc-pandeia-engine-tutorial)
* [HST/STIS spectroscopic ETC](https://etc.stsci.edu/etc/input/stis/spectroscopic/)






