import lambda = require('@aws-cdk/aws-lambda');
import { Construct, Resource } from '@aws-cdk/cdk';
import { ISecret } from './secret';
/**
 * Options to add a rotation schedule to a secret.
 */
export interface RotationScheduleOptions {
    /**
     * THe Lambda function that can rotate the secret.
     */
    readonly rotationLambda: lambda.IFunction;
    /**
     * Specifies the number of days after the previous rotation before
     * Secrets Manager triggers the next automatic rotation.
     *
     * @default 30
     */
    readonly automaticallyAfterDays?: number;
}
/**
 * Construction properties for a RotationSchedule.
 */
export interface RotationScheduleProps extends RotationScheduleOptions {
    /**
     * The secret to rotate.
     */
    readonly secret: ISecret;
}
/**
 * A rotation schedule.
 */
export declare class RotationSchedule extends Resource {
    constructor(scope: Construct, id: string, props: RotationScheduleProps);
}
