"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/cdk");
const secretsmanager = require("../lib");
class ExampleStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const loginSecret = secretsmanager.Secret.fromSecretAttributes(this, 'Secret', {
            secretArn: 'SomeLogin'
        });
        new iam.User(this, 'User', {
            // Get the 'password' field from the secret that looks like
            // { "username": "XXXX", "password": "YYYY" }
            password: loginSecret.secretJsonValue('password')
        });
        /// !hide
    }
}
const app = new cdk.App();
new ExampleStack(app, 'aws-cdk-secret-integ');
app.run();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhhbXBsZS5hcHAtd2l0aC1zZWNyZXQubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXhhbXBsZS5hcHAtd2l0aC1zZWNyZXQubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQXlDO0FBQ3pDLG9DQUFxQztBQUNyQyx5Q0FBMEM7QUFFMUMsTUFBTSxZQUFhLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDbEMsWUFBWSxLQUFjLEVBQUUsRUFBVTtRQUNwQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLFNBQVM7UUFDVCxNQUFNLFdBQVcsR0FBRyxjQUFjLENBQUMsTUFBTSxDQUFDLG9CQUFvQixDQUFDLElBQUksRUFBRSxRQUFRLEVBQUU7WUFDN0UsU0FBUyxFQUFFLFdBQVc7U0FDdkIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDekIsMkRBQTJEO1lBQzNELDZDQUE2QztZQUM3QyxRQUFRLEVBQUUsV0FBVyxDQUFDLGVBQWUsQ0FBQyxVQUFVLENBQUM7U0FDbEQsQ0FBQyxDQUFDO1FBQ0gsU0FBUztJQUVYLENBQUM7Q0FDRjtBQUVELE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLElBQUksWUFBWSxDQUFDLEdBQUcsRUFBRSxzQkFBc0IsQ0FBQyxDQUFDO0FBQzlDLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpYW0gPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtaWFtJyk7XG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY2RrJyk7XG5pbXBvcnQgc2VjcmV0c21hbmFnZXIgPSByZXF1aXJlKCcuLi9saWInKTtcblxuY2xhc3MgRXhhbXBsZVN0YWNrIGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5BcHAsIGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgLy8vICFzaG93XG4gICAgY29uc3QgbG9naW5TZWNyZXQgPSBzZWNyZXRzbWFuYWdlci5TZWNyZXQuZnJvbVNlY3JldEF0dHJpYnV0ZXModGhpcywgJ1NlY3JldCcsIHtcbiAgICAgIHNlY3JldEFybjogJ1NvbWVMb2dpbidcbiAgICB9KTtcblxuICAgIG5ldyBpYW0uVXNlcih0aGlzLCAnVXNlcicsIHtcbiAgICAgIC8vIEdldCB0aGUgJ3Bhc3N3b3JkJyBmaWVsZCBmcm9tIHRoZSBzZWNyZXQgdGhhdCBsb29rcyBsaWtlXG4gICAgICAvLyB7IFwidXNlcm5hbWVcIjogXCJYWFhYXCIsIFwicGFzc3dvcmRcIjogXCJZWVlZXCIgfVxuICAgICAgcGFzc3dvcmQ6IGxvZ2luU2VjcmV0LnNlY3JldEpzb25WYWx1ZSgncGFzc3dvcmQnKVxuICAgIH0pO1xuICAgIC8vLyAhaGlkZVxuXG4gIH1cbn1cblxuY29uc3QgYXBwID0gbmV3IGNkay5BcHAoKTtcbm5ldyBFeGFtcGxlU3RhY2soYXBwLCAnYXdzLWNkay1zZWNyZXQtaW50ZWcnKTtcbmFwcC5ydW4oKTsiXX0=