"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/cdk");
const secretsManager = require("../lib");
class SecretsManagerStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const role = new iam.Role(this, 'TestRole', { assumedBy: new iam.AccountRootPrincipal() });
        /// !show
        // Default secret
        const secret = new secretsManager.Secret(this, 'Secret');
        secret.grantRead(role);
        new iam.User(this, 'User', {
            password: secret.secretValue
        });
        // Templated secret
        const templatedSecret = new secretsManager.Secret(this, 'TemplatedSecret', {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({ username: 'user' }),
                generateStringKey: 'password'
            }
        });
        new iam.User(this, 'OtherUser', {
            userName: templatedSecret.secretJsonValue('username').toString(),
            password: templatedSecret.secretJsonValue('password')
        });
        /// !hide
    }
}
const app = new cdk.App();
new SecretsManagerStack(app, 'Integ-SecretsManager-Secret');
app.run();
//# sourceMappingURL=data:application/json;base64,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