# This file was automatically generated by generate_cli.py

import enum
from typing import Literal, Optional, overload

from bec_widgets.cli.client_utils import BECGuiClientMixin, RPCBase, rpc_call

# pylint: skip-file


class Widgets(str, enum.Enum):
    """
    Enum for the available widgets.
    """

    BECDock = "BECDock"
    BECDockArea = "BECDockArea"
    BECFigure = "BECFigure"
    BECImageWidget = "BECImageWidget"
    BECMotorMapWidget = "BECMotorMapWidget"
    BECQueue = "BECQueue"
    BECStatusBox = "BECStatusBox"
    BECWaveformWidget = "BECWaveformWidget"
    DeviceBox = "DeviceBox"
    DeviceComboBox = "DeviceComboBox"
    DeviceLineEdit = "DeviceLineEdit"
    RingProgressBar = "RingProgressBar"
    ScanControl = "ScanControl"
    StopButton = "StopButton"
    TextBox = "TextBox"
    VSCodeEditor = "VSCodeEditor"
    WebsiteWidget = "WebsiteWidget"


class BECCurve(RPCBase):
    @rpc_call
    def remove(self):
        """
        Remove the curve from the plot.
        """

    @property
    @rpc_call
    def dap_params(self):
        """
        None
        """

    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the curve.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - color: str
            - symbol: str
            - symbol_color: str
            - symbol_size: int
            - pen_width: int
            - pen_style: Literal["solid", "dash", "dot", "dashdot"]
        """

    @rpc_call
    def set_data(self, x, y):
        """
        None
        """

    @rpc_call
    def set_color(self, color: "str", symbol_color: "Optional[str]" = None):
        """
        Change the color of the curve.

        Args:
            color(str): Color of the curve.
            symbol_color(str, optional): Color of the symbol. Defaults to None.
        """

    @rpc_call
    def set_color_map_z(self, colormap: "str"):
        """
        Set the colormap for the scatter plot z gradient.

        Args:
            colormap(str): Colormap for the scatter plot.
        """

    @rpc_call
    def set_symbol(self, symbol: "str"):
        """
        Change the symbol of the curve.

        Args:
            symbol(str): Symbol of the curve.
        """

    @rpc_call
    def set_symbol_color(self, symbol_color: "str"):
        """
        Change the symbol color of the curve.

        Args:
            symbol_color(str): Color of the symbol.
        """

    @rpc_call
    def set_symbol_size(self, symbol_size: "int"):
        """
        Change the symbol size of the curve.

        Args:
            symbol_size(int): Size of the symbol.
        """

    @rpc_call
    def set_pen_width(self, pen_width: "int"):
        """
        Change the pen width of the curve.

        Args:
            pen_width(int): Width of the pen.
        """

    @rpc_call
    def set_pen_style(self, pen_style: "Literal['solid', 'dash', 'dot', 'dashdot']"):
        """
        Change the pen style of the curve.

        Args:
            pen_style(Literal["solid", "dash", "dot", "dashdot"]): Style of the pen.
        """

    @rpc_call
    def get_data(self) -> "tuple[np.ndarray, np.ndarray]":
        """
        Get the data of the curve.
        Returns:
            tuple[np.ndarray,np.ndarray]: X and Y data of the curve.
        """

    @property
    @rpc_call
    def dap_params(self):
        """
        None
        """


class BECDock(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def widget_list(self) -> "list[BECWidget]":
        """
        Get the widgets in the dock.

        Returns:
            widgets(list): The widgets in the dock.
        """

    @rpc_call
    def show_title_bar(self):
        """
        Hide the title bar of the dock.
        """

    @rpc_call
    def hide_title_bar(self):
        """
        Hide the title bar of the dock.
        """

    @rpc_call
    def get_widgets_positions(self) -> "dict":
        """
        Get the positions of the widgets in the dock.

        Returns:
            dict: The positions of the widgets in the dock as dict -> {(row, col, rowspan, colspan):widget}
        """

    @rpc_call
    def set_title(self, title: "str"):
        """
        Set the title of the dock.

        Args:
            title(str): The title of the dock.
        """

    @rpc_call
    def add_widget(
        self,
        widget: "BECWidget | str",
        row=None,
        col=0,
        rowspan=1,
        colspan=1,
        shift: "Literal['down', 'up', 'left', 'right']" = "down",
    ) -> "BECWidget":
        """
        Add a widget to the dock.

        Args:
            widget(QWidget): The widget to add.
            row(int): The row to add the widget to. If None, the widget will be added to the next available row.
            col(int): The column to add the widget to.
            rowspan(int): The number of rows the widget should span.
            colspan(int): The number of columns the widget should span.
            shift(Literal["down", "up", "left", "right"]): The direction to shift the widgets if the position is occupied.
        """

    @rpc_call
    def list_eligible_widgets(self) -> "list":
        """
        List all widgets that can be added to the dock.

        Returns:
            list: The list of eligible widgets.
        """

    @rpc_call
    def move_widget(self, widget: "QWidget", new_row: "int", new_col: "int"):
        """
        Move a widget to a new position in the layout.

        Args:
            widget(QWidget): The widget to move.
            new_row(int): The new row to move the widget to.
            new_col(int): The new column to move the widget to.
        """

    @rpc_call
    def remove_widget(self, widget_rpc_id: "str"):
        """
        Remove a widget from the dock.

        Args:
            widget_rpc_id(str): The ID of the widget to remove.
        """

    @rpc_call
    def remove(self):
        """
        Remove the dock from the parent dock area.
        """

    @rpc_call
    def attach(self):
        """
        Attach the dock to the parent dock area.
        """

    @rpc_call
    def detach(self):
        """
        Detach the dock from the parent dock area.
        """


class BECDockArea(RPCBase, BECGuiClientMixin):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @property
    @rpc_call
    def panels(self) -> "dict[str, BECDock]":
        """
        Get the docks in the dock area.
        Returns:
            dock_dict(dict): The docks in the dock area.
        """

    @rpc_call
    def save_state(self) -> "dict":
        """
        Save the state of the dock area.

        Returns:
            dict: The state of the dock area.
        """

    @rpc_call
    def remove_dock(self, name: "str"):
        """
        Remove a dock by name and ensure it is properly closed and cleaned up.

        Args:
            name(str): The name of the dock to remove.
        """

    @rpc_call
    def restore_state(
        self, state: "dict" = None, missing: "Literal['ignore', 'error']" = "ignore", extra="bottom"
    ):
        """
        Restore the state of the dock area. If no state is provided, the last state is restored.

        Args:
            state(dict): The state to restore.
            missing(Literal['ignore','error']): What to do if a dock is missing.
            extra(str): Extra docks that are in the dockarea but that are not mentioned in state will be added to the bottom of the dockarea, unless otherwise specified by the extra argument.
        """

    @rpc_call
    def add_dock(
        self,
        name: "str" = None,
        position: "Literal['bottom', 'top', 'left', 'right', 'above', 'below']" = None,
        relative_to: "BECDock | None" = None,
        closable: "bool" = True,
        floating: "bool" = False,
        prefix: "str" = "dock",
        widget: "str | QWidget | None" = None,
        row: "int" = None,
        col: "int" = 0,
        rowspan: "int" = 1,
        colspan: "int" = 1,
    ) -> "BECDock":
        """
        Add a dock to the dock area. Dock has QGridLayout as layout manager by default.

        Args:
            name(str): The name of the dock to be displayed and for further references. Has to be unique.
            position(Literal["bottom", "top", "left", "right", "above", "below"]): The position of the dock.
            relative_to(BECDock): The dock to which the new dock should be added relative to.
            closable(bool): Whether the dock is closable.
            floating(bool): Whether the dock is detached after creating.
            prefix(str): The prefix for the dock name if no name is provided.
            widget(str|QWidget|None): The widget to be added to the dock. While using RPC, only BEC RPC widgets from RPCWidgetHandler are allowed.
            row(int): The row of the added widget.
            col(int): The column of the added widget.
            rowspan(int): The rowspan of the added widget.
            colspan(int): The colspan of the added widget.

        Returns:
            BECDock: The created dock.
        """

    @rpc_call
    def clear_all(self):
        """
        Close all docks and remove all temp areas.
        """

    @rpc_call
    def detach_dock(self, dock_name: "str") -> "BECDock":
        """
        Undock a dock from the dock area.

        Args:
            dock_name(str): The dock to undock.

        Returns:
            BECDock: The undocked dock.
        """

    @rpc_call
    def attach_all(self):
        """
        Return all floating docks to the dock area.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """

    @property
    @rpc_call
    def temp_areas(self) -> "list":
        """
        Get the temporary areas in the dock area.

        Returns:
            list: The temporary areas in the dock area.
        """


class BECFigure(RPCBase):
    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """

    @rpc_call
    def axes(self, row: "int", col: "int") -> "BECPlotBase":
        """
        Get widget by its coordinates in the figure.

        Args:
            row(int): the row coordinate
            col(int): the column coordinate

        Returns:
            BECPlotBase: the widget at the given coordinates
        """

    @property
    @rpc_call
    def widgets(self) -> "dict":
        """
        All widgets within the figure with gui ids as keys.
        Returns:
            dict: All widgets within the figure.
        """

    @rpc_call
    def plot(
        self,
        arg1: "list | np.ndarray | str | None" = None,
        y: "list | np.ndarray | None" = None,
        x: "list | np.ndarray | None" = None,
        x_name: "str | None" = None,
        y_name: "str | None" = None,
        z_name: "str | None" = None,
        x_entry: "str | None" = None,
        y_entry: "str | None" = None,
        z_entry: "str | None" = None,
        color: "str | None" = None,
        color_map_z: "str | None" = "plasma",
        label: "str | None" = None,
        validate: "bool" = True,
        new: "bool" = False,
        row: "int | None" = None,
        col: "int | None" = None,
        dap: "str | None" = None,
        config: "dict | None" = None,
        **axis_kwargs,
    ) -> "BECWaveform":
        """
        Add a 1D waveform plot to the figure. Always access the first waveform widget in the figure.

        Args:
            arg1(list | np.ndarray | str | None): First argument which can be x data, y data, or y_name.
            y(list | np.ndarray): Custom y data to plot.
            x(list | np.ndarray): Custom x data to plot.
            x_name(str): The name of the device for the x-axis.
            y_name(str): The name of the device for the y-axis.
            z_name(str): The name of the device for the z-axis.
            x_entry(str): The name of the entry for the x-axis.
            y_entry(str): The name of the entry for the y-axis.
            z_entry(str): The name of the entry for the z-axis.
            color(str): The color of the curve.
            color_map_z(str): The color map to use for the z-axis.
            label(str): The label of the curve.
            validate(bool): If True, validate the device names and entries.
            new(bool): If True, create a new plot instead of using the first plot.
            row(int): The row coordinate of the widget in the figure. If not provided, the next empty row will be used.
            col(int): The column coordinate of the widget in the figure. If not provided, the next empty column will be used.
            dap(str): The DAP model to use for the curve.
            config(dict): Recreates the whole BECWaveform widget from provided configuration.
            **axis_kwargs: Additional axis properties to set on the widget after creation.

        Returns:
            BECWaveform: The waveform plot widget.
        """

    @rpc_call
    def image(
        self,
        monitor: "str" = None,
        color_bar: "Literal['simple', 'full']" = "full",
        color_map: "str" = "magma",
        data: "np.ndarray" = None,
        vrange: "tuple[float, float]" = None,
        new: "bool" = False,
        row: "int | None" = None,
        col: "int | None" = None,
        config: "dict | None" = None,
        **axis_kwargs,
    ) -> "BECImageShow":
        """
        Add an image to the figure. Always access the first image widget in the figure.

        Args:
            monitor(str): The name of the monitor to display.
            color_bar(Literal["simple","full"]): The type of color bar to display.
            color_map(str): The color map to use for the image.
            data(np.ndarray): Custom data to display.
            vrange(tuple[float, float]): The range of values to display.
            new(bool): If True, create a new plot instead of using the first plot.
            row(int): The row coordinate of the widget in the figure. If not provided, the next empty row will be used.
            col(int): The column coordinate of the widget in the figure. If not provided, the next empty column will be used.
            config(dict): Recreates the whole BECImageShow widget from provided configuration.
            **axis_kwargs: Additional axis properties to set on the widget after creation.

        Returns:
            BECImageShow: The image widget.
        """

    @rpc_call
    def motor_map(
        self,
        motor_x: "str" = None,
        motor_y: "str" = None,
        new: "bool" = False,
        row: "int | None" = None,
        col: "int | None" = None,
        config: "dict | None" = None,
        **axis_kwargs,
    ) -> "BECMotorMap":
        """
        Add a motor map to the figure. Always access the first motor map widget in the figure.

        Args:
            motor_x(str): The name of the motor for the X axis.
            motor_y(str): The name of the motor for the Y axis.
            new(bool): If True, create a new plot instead of using the first plot.
            row(int): The row coordinate of the widget in the figure. If not provided, the next empty row will be used.
            col(int): The column coordinate of the widget in the figure. If not provided, the next empty column will be used.
            config(dict): Recreates the whole BECImageShow widget from provided configuration.
            **axis_kwargs: Additional axis properties to set on the widget after creation.

        Returns:
            BECMotorMap: The motor map widget.
        """

    @rpc_call
    def remove(
        self,
        row: "int" = None,
        col: "int" = None,
        widget_id: "str" = None,
        coordinates: "tuple[int, int]" = None,
    ) -> "None":
        """
        Remove a widget from the figure. Can be removed by its unique identifier or by its coordinates.

        Args:
            row(int): The row coordinate of the widget to remove.
            col(int): The column coordinate of the widget to remove.
            widget_id(str): The unique identifier of the widget to remove.
            coordinates(tuple[int, int], optional): The coordinates of the widget to remove.
        """

    @rpc_call
    def change_layout(self, max_columns=None, max_rows=None):
        """
        Reshuffle the layout of the figure to adjust to a new number of max_columns or max_rows.
        If both max_columns and max_rows are provided, max_rows is ignored.

        Args:
            max_columns (Optional[int]): The new maximum number of columns in the figure.
            max_rows (Optional[int]): The new maximum number of rows in the figure.
        """

    @rpc_call
    def change_theme(self, theme: "Literal['dark', 'light']") -> "None":
        """
        Change the theme of the figure widget.

        Args:
            theme(Literal["dark","light"]): The theme to set for the figure widget.
        """

    @rpc_call
    def export(self):
        """
        Export the plot widget.
        """

    @rpc_call
    def clear_all(self):
        """
        Clear all widgets from the figure and reset to default state
        """

    @property
    @rpc_call
    def widget_list(self) -> "list[BECPlotBase]":
        """
        Access all widget in BECFigure as a list
        Returns:
            list[BECPlotBase]: List of all widgets in the figure.
        """


class BECImageItem(RPCBase):
    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the image.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - downsample
            - color_map
            - monitor
            - opacity
            - vrange
            - fft
            - log
            - rot
            - transpose
            - autorange_mode
        """

    @rpc_call
    def set_fft(self, enable: "bool" = False):
        """
        Set the FFT of the image.

        Args:
            enable(bool): Whether to perform FFT on the monitor data.
        """

    @rpc_call
    def set_log(self, enable: "bool" = False):
        """
        Set the log of the image.

        Args:
            enable(bool): Whether to perform log on the monitor data.
        """

    @rpc_call
    def set_rotation(self, deg_90: "int" = 0):
        """
        Set the rotation of the image.

        Args:
            deg_90(int): The rotation angle of the monitor data before displaying.
        """

    @rpc_call
    def set_transpose(self, enable: "bool" = False):
        """
        Set the transpose of the image.

        Args:
            enable(bool): Whether to transpose the image.
        """

    @rpc_call
    def set_opacity(self, opacity: "float" = 1.0):
        """
        Set the opacity of the image.

        Args:
            opacity(float): The opacity of the image.
        """

    @rpc_call
    def set_autorange(self, autorange: "bool" = False):
        """
        Set the autorange of the color bar.

        Args:
            autorange(bool): Whether to autorange the color bar.
        """

    @rpc_call
    def set_autorange_mode(self, mode: "Literal['max', 'mean']" = "mean"):
        """
        Set the autorange mode to scale the vrange of the color bar. Choose between min/max or mean +/- std.

        Args:
            mode(Literal["max","mean"]): Max for min/max or mean for mean +/- std.
        """

    @rpc_call
    def set_color_map(self, cmap: "str" = "magma"):
        """
        Set the color map of the image.

        Args:
            cmap(str): The color map of the image.
        """

    @rpc_call
    def set_auto_downsample(self, auto: "bool" = True):
        """
        Set the auto downsample of the image.

        Args:
            auto(bool): Whether to downsample the image.
        """

    @rpc_call
    def set_monitor(self, monitor: "str"):
        """
        Set the monitor of the image.

        Args:
            monitor(str): The name of the monitor.
        """

    @rpc_call
    def set_vrange(
        self,
        vmin: "float" = None,
        vmax: "float" = None,
        vrange: "tuple[float, float]" = None,
        change_autorange: "bool" = True,
    ):
        """
        Set the range of the color bar.

        Args:
            vmin(float): Minimum value of the color bar.
            vmax(float): Maximum value of the color bar.
        """

    @rpc_call
    def get_data(self) -> "np.ndarray":
        """
        Get the data of the image.
        Returns:
            np.ndarray: The data of the image.
        """


class BECImageShow(RPCBase):
    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def add_image_by_config(self, config: "ImageItemConfig | dict") -> "BECImageItem":
        """
        Add an image to the widget by configuration.

        Args:
            config(ImageItemConfig|dict): The configuration of the image.

        Returns:
            BECImageItem: The image object.
        """

    @rpc_call
    def image(
        self,
        monitor: "str",
        color_map: "Optional[str]" = "magma",
        color_bar: "Optional[Literal['simple', 'full']]" = "full",
        downsample: "Optional[bool]" = True,
        opacity: "Optional[float]" = 1.0,
        vrange: "Optional[tuple[int, int]]" = None,
        **kwargs,
    ) -> "BECImageItem":
        """
        Add an image to the figure. Always access the first image widget in the figure.

        Args:
            monitor(str): The name of the monitor to display.
            color_bar(Literal["simple","full"]): The type of color bar to display.
            color_map(str): The color map to use for the image.
            data(np.ndarray): Custom data to display.
            vrange(tuple[float, float]): The range of values to display.

        Returns:
            BECImageItem: The image item.
        """

    @rpc_call
    def add_custom_image(
        self,
        name: "str",
        data: "Optional[np.ndarray]" = None,
        color_map: "Optional[str]" = "magma",
        color_bar: "Optional[Literal['simple', 'full']]" = "full",
        downsample: "Optional[bool]" = True,
        opacity: "Optional[float]" = 1.0,
        vrange: "Optional[tuple[int, int]]" = None,
        **kwargs,
    ):
        """
        None
        """

    @rpc_call
    def set_vrange(self, vmin: "float", vmax: "float", name: "str" = None):
        """
        Set the range of the color bar.
        If name is not specified, then set vrange for all images.

        Args:
            vmin(float): Minimum value of the color bar.
            vmax(float): Maximum value of the color bar.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_color_map(self, cmap: "str", name: "str" = None):
        """
        Set the color map of the image.
        If name is not specified, then set color map for all images.

        Args:
            cmap(str): The color map of the image.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_autorange(self, enable: "bool" = False, name: "str" = None):
        """
        Set the autoscale of the image.

        Args:
            enable(bool): Whether to autoscale the color bar.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_autorange_mode(self, mode: "Literal['max', 'mean']", name: "str" = None):
        """
        Set the autoscale mode of the image, that decides how the vrange of the color bar is scaled.
        Choose betwen 'max' -> min/max of the data, 'mean' -> mean +/- fudge_factor*std of the data (fudge_factor~2).

        Args:
            mode(str): The autoscale mode of the image.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_monitor(self, monitor: "str", name: "str" = None):
        """
        Set the monitor of the image.
        If name is not specified, then set monitor for all images.

        Args:
            monitor(str): The name of the monitor.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_processing(self, name: "str" = None, **kwargs):
        """
        Set the post processing of the image.
        If name is not specified, then set post processing for all images.

        Args:
            name(str): The name of the image. If None, apply to all images.
            **kwargs: Keyword arguments for the properties to be set.
        Possible properties:
            - fft: bool
            - log: bool
            - rot: int
            - transpose: bool
        """

    @rpc_call
    def set_image_properties(self, name: "str" = None, **kwargs):
        """
        Set the properties of the image.

        Args:
            name(str): The name of the image. If None, apply to all images.
            **kwargs: Keyword arguments for the properties to be set.
        Possible properties:
            - downsample: bool
            - color_map: str
            - monitor: str
            - opacity: float
            - vrange: tuple[int,int]
            - fft: bool
            - log: bool
            - rot: int
            - transpose: bool
        """

    @rpc_call
    def set_fft(self, enable: "bool" = False, name: "str" = None):
        """
        Set the FFT of the image.
        If name is not specified, then set FFT for all images.

        Args:
            enable(bool): Whether to perform FFT on the monitor data.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_log(self, enable: "bool" = False, name: "str" = None):
        """
        Set the log of the image.
        If name is not specified, then set log for all images.

        Args:
            enable(bool): Whether to perform log on the monitor data.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_rotation(self, deg_90: "int" = 0, name: "str" = None):
        """
        Set the rotation of the image.
        If name is not specified, then set rotation for all images.

        Args:
            deg_90(int): The rotation angle of the monitor data before displaying.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_transpose(self, enable: "bool" = False, name: "str" = None):
        """
        Set the transpose of the image.
        If name is not specified, then set transpose for all images.

        Args:
            enable(bool): Whether to transpose the monitor data before displaying.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set(self, **kwargs) -> "None":
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @rpc_call
    def set_title(self, title: "str", size: "int" = None):
        """
        Set the title of the plot widget.

        Args:
            title(str): Title of the plot widget.
            size(int): Font size of the title.
        """

    @rpc_call
    def set_x_label(self, label: "str", size: "int" = None):
        """
        Set the label of the x-axis.

        Args:
            label(str): Label of the x-axis.
            size(int): Font size of the label.
        """

    @rpc_call
    def set_y_label(self, label: "str", size: "int" = None):
        """
        Set the label of the y-axis.

        Args:
            label(str): Label of the y-axis.
            size(int): Font size of the label.
        """

    @rpc_call
    def set_x_scale(self, scale: "Literal['linear', 'log']" = "linear"):
        """
        Set the scale of the x-axis.

        Args:
            scale(Literal["linear", "log"]): Scale of the x-axis.
        """

    @rpc_call
    def set_y_scale(self, scale: "Literal['linear', 'log']" = "linear"):
        """
        Set the scale of the y-axis.

        Args:
            scale(Literal["linear", "log"]): Scale of the y-axis.
        """

    @rpc_call
    def set_x_lim(self, *args) -> "None":
        """
        Set the limits of the x-axis. This method can accept either two separate arguments
        for the minimum and maximum x-axis values, or a single tuple containing both limits.

        Usage:
            set_x_lim(x_min, x_max)
            set_x_lim((x_min, x_max))

        Args:
            *args: A variable number of arguments. Can be two integers (x_min and x_max)
                   or a single tuple with two integers.
        """

    @rpc_call
    def set_y_lim(self, *args) -> "None":
        """
        Set the limits of the y-axis. This method can accept either two separate arguments
        for the minimum and maximum y-axis values, or a single tuple containing both limits.

        Usage:
            set_y_lim(y_min, y_max)
            set_y_lim((y_min, y_max))

        Args:
            *args: A variable number of arguments. Can be two integers (y_min and y_max)
                   or a single tuple with two integers.
        """

    @rpc_call
    def set_grid(self, x: "bool" = False, y: "bool" = False):
        """
        Set the grid of the plot widget.

        Args:
            x(bool): Show grid on the x-axis.
            y(bool): Show grid on the y-axis.
        """

    @rpc_call
    def lock_aspect_ratio(self, lock):
        """
        Lock aspect ratio.

        Args:
            lock(bool): True to lock, False to unlock.
        """

    @rpc_call
    def export(self):
        """
        Show the Export Dialog of the plot widget.
        """

    @rpc_call
    def remove(self):
        """
        Remove the plot widget from the figure.
        """

    @property
    @rpc_call
    def images(self) -> "list[BECImageItem]":
        """
        Get the list of images.
        Returns:
            list[BECImageItem]: The list of images.
        """


class BECImageWidget(RPCBase):
    @rpc_call
    def image(
        self,
        monitor: "str",
        color_map: "Optional[str]" = "magma",
        color_bar: "Optional[Literal['simple', 'full']]" = "full",
        downsample: "Optional[bool]" = True,
        opacity: "Optional[float]" = 1.0,
        vrange: "Optional[tuple[int, int]]" = None,
        **kwargs,
    ) -> "BECImageItem":
        """
        None
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @rpc_call
    def set_title(self, title: "str"):
        """
        Set the title of the plot widget.

        Args:
            title(str): Title of the plot.
        """

    @rpc_call
    def set_x_label(self, x_label: "str"):
        """
        Set the x-axis label of the plot widget.

        Args:
            x_label(str): Label of the x-axis.
        """

    @rpc_call
    def set_y_label(self, y_label: "str"):
        """
        Set the y-axis label of the plot widget.

        Args:
            y_label(str): Label of the y-axis.
        """

    @rpc_call
    def set_x_scale(self, x_scale: "Literal['linear', 'log']"):
        """
        Set the scale of the x-axis of the plot widget.

        Args:
            x_scale(Literal["linear", "log"]): Scale of the x-axis.
        """

    @rpc_call
    def set_y_scale(self, y_scale: "Literal['linear', 'log']"):
        """
        Set the scale of the y-axis of the plot widget.

        Args:
            y_scale(Literal["linear", "log"]): Scale of the y-axis.
        """

    @rpc_call
    def set_x_lim(self, x_lim: "tuple"):
        """
        Set the limits of the x-axis of the plot widget.

        Args:
            x_lim(tuple): Limits of the x-axis.
        """

    @rpc_call
    def set_y_lim(self, y_lim: "tuple"):
        """
        Set the limits of the y-axis of the plot widget.

        Args:
            y_lim(tuple): Limits of the y-axis.
        """

    @rpc_call
    def set_vrange(self, vmin: "float", vmax: "float", name: "str" = None):
        """
        Set the range of the color bar.
        If name is not specified, then set vrange for all images.

        Args:
            vmin(float): Minimum value of the color bar.
            vmax(float): Maximum value of the color bar.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_fft(self, enable: "bool" = False, name: "str" = None):
        """
        Set the FFT of the image.
        If name is not specified, then set FFT for all images.

        Args:
            enable(bool): Whether to perform FFT on the monitor data.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_transpose(self, enable: "bool" = False, name: "str" = None):
        """
        Set the transpose of the image.
        If name is not specified, then set transpose for all images.

        Args:
            enable(bool): Whether to transpose the monitor data before displaying.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_rotation(self, deg_90: "int" = 0, name: "str" = None):
        """
        Set the rotation of the image.
        If name is not specified, then set rotation for all images.

        Args:
            deg_90(int): The rotation angle of the monitor data before displaying.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_log(self, enable: "bool" = False, name: "str" = None):
        """
        Set the log of the image.
        If name is not specified, then set log for all images.

        Args:
            enable(bool): Whether to perform log on the monitor data.
            name(str): The name of the image. If None, apply to all images.
        """

    @rpc_call
    def set_grid(self, x_grid: "bool", y_grid: "bool"):
        """
        Set the grid visibility of the plot widget.

        Args:
            x_grid(bool): Visibility of the x-axis grid.
            y_grid(bool): Visibility of the y-axis grid.
        """

    @rpc_call
    def lock_aspect_ratio(self, lock: "bool"):
        """
        Lock the aspect ratio of the plot widget.

        Args:
            lock(bool): Lock the aspect ratio.
        """


class BECMotorMap(RPCBase):
    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def change_motors(
        self,
        motor_x: "str",
        motor_y: "str",
        motor_x_entry: "str" = None,
        motor_y_entry: "str" = None,
        validate_bec: "bool" = True,
    ) -> "None":
        """
        Change the active motors for the plot.

        Args:
            motor_x(str): Motor name for the X axis.
            motor_y(str): Motor name for the Y axis.
            motor_x_entry(str): Motor entry for the X axis.
            motor_y_entry(str): Motor entry for the Y axis.
            validate_bec(bool, optional): If True, validate the signal with BEC. Defaults to True.
        """

    @rpc_call
    def set_max_points(self, max_points: "int") -> "None":
        """
        Set the maximum number of points to display.

        Args:
            max_points(int): Maximum number of points to display.
        """

    @rpc_call
    def set_precision(self, precision: "int") -> "None":
        """
        Set the decimal precision of the motor position.

        Args:
            precision(int): Decimal precision of the motor position.
        """

    @rpc_call
    def set_num_dim_points(self, num_dim_points: "int") -> "None":
        """
        Set the number of dim points for the motor map.

        Args:
            num_dim_points(int): Number of dim points.
        """

    @rpc_call
    def set_background_value(self, background_value: "int") -> "None":
        """
        Set the background value of the motor map.

        Args:
            background_value(int): Background value of the motor map.
        """

    @rpc_call
    def set_scatter_size(self, scatter_size: "int") -> "None":
        """
        Set the scatter size of the motor map plot.

        Args:
            scatter_size(int): Size of the scatter points.
        """

    @rpc_call
    def get_data(self) -> "dict":
        """
        Get the data of the motor map.

        Returns:
            dict: Data of the motor map.
        """

    @rpc_call
    def export(self):
        """
        Show the Export Dialog of the plot widget.
        """

    @rpc_call
    def remove(self):
        """
        Remove the plot widget from the figure.
        """

    @rpc_call
    def reset_history(self):
        """
        Reset the history of the motor map.
        """


class BECMotorMapWidget(RPCBase):
    @rpc_call
    def change_motors(
        self,
        motor_x: "str",
        motor_y: "str",
        motor_x_entry: "str" = None,
        motor_y_entry: "str" = None,
        validate_bec: "bool" = True,
    ) -> "None":
        """
        Change the active motors for the plot.

        Args:
            motor_x(str): Motor name for the X axis.
            motor_y(str): Motor name for the Y axis.
            motor_x_entry(str): Motor entry for the X axis.
            motor_y_entry(str): Motor entry for the Y axis.
            validate_bec(bool, optional): If True, validate the signal with BEC. Defaults to True.
        """

    @rpc_call
    def set_max_points(self, max_points: "int") -> "None":
        """
        Set the maximum number of points to display on the motor map.

        Args:
            max_points(int): Maximum number of points to display.
        """

    @rpc_call
    def set_precision(self, precision: "int") -> "None":
        """
        Set the precision of the motor map.

        Args:
            precision(int): Precision to set.
        """

    @rpc_call
    def set_num_dim_points(self, num_dim_points: "int") -> "None":
        """
        Set the number of points to display on the motor map.

        Args:
            num_dim_points(int): Number of points to display.
        """

    @rpc_call
    def set_background_value(self, background_value: "int") -> "None":
        """
        Set the background value of the motor map.

        Args:
            background_value(int): Background value of the motor map.
        """

    @rpc_call
    def set_scatter_size(self, scatter_size: "int") -> "None":
        """
        Set the scatter size of the motor map.

        Args:
            scatter_size(int): Scatter size of the motor map.
        """

    @rpc_call
    def get_data(self) -> "dict":
        """
        Get the data of the motor map.

        Returns:
            dict: Data of the motor map.
        """

    @rpc_call
    def reset_history(self) -> "None":
        """
        Reset the history of the motor map.
        """

    @rpc_call
    def export(self):
        """
        Show the export dialog for the motor map.
        """


class BECPlotBase(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def set(self, **kwargs) -> "None":
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @rpc_call
    def set_title(self, title: "str", size: "int" = None):
        """
        Set the title of the plot widget.

        Args:
            title(str): Title of the plot widget.
            size(int): Font size of the title.
        """

    @rpc_call
    def set_x_label(self, label: "str", size: "int" = None):
        """
        Set the label of the x-axis.

        Args:
            label(str): Label of the x-axis.
            size(int): Font size of the label.
        """

    @rpc_call
    def set_y_label(self, label: "str", size: "int" = None):
        """
        Set the label of the y-axis.

        Args:
            label(str): Label of the y-axis.
            size(int): Font size of the label.
        """

    @rpc_call
    def set_x_scale(self, scale: "Literal['linear', 'log']" = "linear"):
        """
        Set the scale of the x-axis.

        Args:
            scale(Literal["linear", "log"]): Scale of the x-axis.
        """

    @rpc_call
    def set_y_scale(self, scale: "Literal['linear', 'log']" = "linear"):
        """
        Set the scale of the y-axis.

        Args:
            scale(Literal["linear", "log"]): Scale of the y-axis.
        """

    @rpc_call
    def set_x_lim(self, *args) -> "None":
        """
        Set the limits of the x-axis. This method can accept either two separate arguments
        for the minimum and maximum x-axis values, or a single tuple containing both limits.

        Usage:
            set_x_lim(x_min, x_max)
            set_x_lim((x_min, x_max))

        Args:
            *args: A variable number of arguments. Can be two integers (x_min and x_max)
                   or a single tuple with two integers.
        """

    @rpc_call
    def set_y_lim(self, *args) -> "None":
        """
        Set the limits of the y-axis. This method can accept either two separate arguments
        for the minimum and maximum y-axis values, or a single tuple containing both limits.

        Usage:
            set_y_lim(y_min, y_max)
            set_y_lim((y_min, y_max))

        Args:
            *args: A variable number of arguments. Can be two integers (y_min and y_max)
                   or a single tuple with two integers.
        """

    @rpc_call
    def set_grid(self, x: "bool" = False, y: "bool" = False):
        """
        Set the grid of the plot widget.

        Args:
            x(bool): Show grid on the x-axis.
            y(bool): Show grid on the y-axis.
        """

    @rpc_call
    def lock_aspect_ratio(self, lock):
        """
        Lock aspect ratio.

        Args:
            lock(bool): True to lock, False to unlock.
        """

    @rpc_call
    def export(self):
        """
        Show the Export Dialog of the plot widget.
        """

    @rpc_call
    def remove(self):
        """
        Remove the plot widget from the figure.
        """

    @rpc_call
    def set_legend_label_size(self, size: "int" = None):
        """
        Set the font size of the legend.

        Args:
            size(int): Font size of the legend.
        """


class BECQueue(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """


class BECStatusBox(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """


class BECWaveform(RPCBase):
    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def plot(
        self,
        arg1: "list | np.ndarray | str | None" = None,
        y: "list | np.ndarray | None" = None,
        x: "list | np.ndarray | None" = None,
        x_name: "str | None" = None,
        y_name: "str | None" = None,
        z_name: "str | None" = None,
        x_entry: "str | None" = None,
        y_entry: "str | None" = None,
        z_entry: "str | None" = None,
        color: "str | None" = None,
        color_map_z: "str | None" = "plasma",
        label: "str | None" = None,
        validate: "bool" = True,
        dap: "str | None" = None,
        **kwargs,
    ) -> "BECCurve":
        """
        Plot a curve to the plot widget.

        Args:
            arg1(list | np.ndarray | str | None): First argument which can be x data, y data, or y_name.
            y(list | np.ndarray): Custom y data to plot.
            x(list | np.ndarray): Custom y data to plot.
            x_name(str): Name of the x signal.
                - "best_effort": Use the best effort signal.
                - "timestamp": Use the timestamp signal.
                - "index": Use the index signal.
                - Custom signal name of device from BEC.
            y_name(str): The name of the device for the y-axis.
            z_name(str): The name of the device for the z-axis.
            x_entry(str): The name of the entry for the x-axis.
            y_entry(str): The name of the entry for the y-axis.
            z_entry(str): The name of the entry for the z-axis.
            color(str): The color of the curve.
            color_map_z(str): The color map to use for the z-axis.
            label(str): The label of the curve.
            validate(bool): If True, validate the device names and entries.
            dap(str): The dap model to use for the curve, only available for sync devices. If not specified, none will be added.

        Returns:
            BECCurve: The curve object.
        """

    @rpc_call
    def add_dap(
        self,
        x_name: "str | None" = None,
        y_name: "str | None" = None,
        x_entry: "Optional[str]" = None,
        y_entry: "Optional[str]" = None,
        color: "Optional[str]" = None,
        dap: "str" = "GaussianModel",
        validate_bec: "bool" = True,
        **kwargs,
    ) -> "BECCurve":
        """
        Add LMFIT dap model curve to the plot widget.

        Args:
            x_name(str): Name of the x signal.
            x_entry(str): Entry of the x signal.
            y_name(str): Name of the y signal.
            y_entry(str): Entry of the y signal.
            color(str, optional): Color of the curve. Defaults to None.
            dap(str): The dap model to use for the curve.
            validate_bec(bool, optional): If True, validate the signal with BEC. Defaults to True.
            **kwargs: Additional keyword arguments for the curve configuration.

        Returns:
            BECCurve: The curve object.
        """

    @rpc_call
    def set_x(self, x_name: "str", x_entry: "str | None" = None):
        """
        Change the x axis of the plot widget.

        Args:
            x_name(str): Name of the x signal.
                - "best_effort": Use the best effort signal.
                - "timestamp": Use the timestamp signal.
                - "index": Use the index signal.
                - Custom signal name of device from BEC.
            x_entry(str): Entry of the x signal.
        """

    @rpc_call
    def get_dap_params(self) -> "dict":
        """
        Get the DAP parameters of all DAP curves.

        Returns:
            dict: DAP parameters of all DAP curves.
        """

    @rpc_call
    def remove_curve(self, *identifiers):
        """
        Remove a curve from the plot widget.

        Args:
            *identifiers: Identifier of the curve to be removed. Can be either an integer (index) or a string (curve_id).
        """

    @rpc_call
    def scan_history(self, scan_index: "int" = None, scan_id: "str" = None):
        """
        Update the scan curves with the data from the scan storage.
        Provide only one of scan_id or scan_index.

        Args:
            scan_id(str, optional): ScanID of the scan to be updated. Defaults to None.
            scan_index(int, optional): Index of the scan to be updated. Defaults to None.
        """

    @property
    @rpc_call
    def curves(self) -> "list[BECCurve]":
        """
        Get the curves of the plot widget as a list
        Returns:
            list: List of curves.
        """

    @rpc_call
    def get_curve(self, identifier) -> "BECCurve":
        """
        Get the curve by its index or ID.

        Args:
            identifier(int|str): Identifier of the curve. Can be either an integer (index) or a string (curve_id).

        Returns:
            BECCurve: The curve object.
        """

    @rpc_call
    def get_all_data(self, output: "Literal['dict', 'pandas']" = "dict") -> "dict | pd.DataFrame":
        """
        Extract all curve data into a dictionary or a pandas DataFrame.

        Args:
            output (Literal["dict", "pandas"]): Format of the output data.

        Returns:
            dict | pd.DataFrame: Data of all curves in the specified format.
        """

    @rpc_call
    def set(self, **kwargs) -> "None":
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @rpc_call
    def set_title(self, title: "str", size: "int" = None):
        """
        Set the title of the plot widget.

        Args:
            title(str): Title of the plot widget.
            size(int): Font size of the title.
        """

    @rpc_call
    def set_x_label(self, label: "str", size: "int" = None):
        """
        Set the label of the x-axis.

        Args:
            label(str): Label of the x-axis.
            size(int): Font size of the label.
        """

    @rpc_call
    def set_y_label(self, label: "str", size: "int" = None):
        """
        Set the label of the y-axis.

        Args:
            label(str): Label of the y-axis.
            size(int): Font size of the label.
        """

    @rpc_call
    def set_x_scale(self, scale: "Literal['linear', 'log']" = "linear"):
        """
        Set the scale of the x-axis.

        Args:
            scale(Literal["linear", "log"]): Scale of the x-axis.
        """

    @rpc_call
    def set_y_scale(self, scale: "Literal['linear', 'log']" = "linear"):
        """
        Set the scale of the y-axis.

        Args:
            scale(Literal["linear", "log"]): Scale of the y-axis.
        """

    @rpc_call
    def set_x_lim(self, *args) -> "None":
        """
        Set the limits of the x-axis. This method can accept either two separate arguments
        for the minimum and maximum x-axis values, or a single tuple containing both limits.

        Usage:
            set_x_lim(x_min, x_max)
            set_x_lim((x_min, x_max))

        Args:
            *args: A variable number of arguments. Can be two integers (x_min and x_max)
                   or a single tuple with two integers.
        """

    @rpc_call
    def set_y_lim(self, *args) -> "None":
        """
        Set the limits of the y-axis. This method can accept either two separate arguments
        for the minimum and maximum y-axis values, or a single tuple containing both limits.

        Usage:
            set_y_lim(y_min, y_max)
            set_y_lim((y_min, y_max))

        Args:
            *args: A variable number of arguments. Can be two integers (y_min and y_max)
                   or a single tuple with two integers.
        """

    @rpc_call
    def set_grid(self, x: "bool" = False, y: "bool" = False):
        """
        Set the grid of the plot widget.

        Args:
            x(bool): Show grid on the x-axis.
            y(bool): Show grid on the y-axis.
        """

    @rpc_call
    def set_colormap(self, colormap: "str | None" = None):
        """
        Set the colormap of the plot widget.

        Args:
            colormap(str, optional): Scale the colors of curves to colormap. If None, use the default color palette.
        """

    @rpc_call
    def lock_aspect_ratio(self, lock):
        """
        Lock aspect ratio.

        Args:
            lock(bool): True to lock, False to unlock.
        """

    @rpc_call
    def export(self):
        """
        Show the Export Dialog of the plot widget.
        """

    @rpc_call
    def remove(self):
        """
        Remove the plot widget from the figure.
        """

    @rpc_call
    def clear_all(self):
        """
        None
        """

    @rpc_call
    def set_legend_label_size(self, size: "int" = None):
        """
        Set the font size of the legend.

        Args:
            size(int): Font size of the legend.
        """


class BECWaveformWidget(RPCBase):
    @property
    @rpc_call
    def curves(self) -> "list[BECCurve]":
        """
        Get the curves of the plot widget as a list
        Returns:
            list: List of curves.
        """

    @rpc_call
    def plot(
        self,
        arg1: "list | np.ndarray | str | None" = None,
        x: "list | np.ndarray | None" = None,
        y: "list | np.ndarray | None" = None,
        x_name: "str | None" = None,
        y_name: "str | None" = None,
        z_name: "str | None" = None,
        x_entry: "str | None" = None,
        y_entry: "str | None" = None,
        z_entry: "str | None" = None,
        color: "str | None" = None,
        color_map_z: "str | None" = "plasma",
        label: "str | None" = None,
        validate: "bool" = True,
        dap: "str | None" = None,
        **kwargs,
    ) -> "BECCurve":
        """
        Plot a curve to the plot widget.
        Args:
            arg1(list | np.ndarray | str | None): First argument which can be x data(list | np.ndarray), y data(list | np.ndarray), or y_name(str).
            x(list | np.ndarray): Custom x data to plot.
            y(list | np.ndarray): Custom y data to plot.
            x_name(str): The name of the device for the x-axis.
            y_name(str): The name of the device for the y-axis.
            z_name(str): The name of the device for the z-axis.
            x_entry(str): The name of the entry for the x-axis.
            y_entry(str): The name of the entry for the y-axis.
            z_entry(str): The name of the entry for the z-axis.
            color(str): The color of the curve.
            color_map_z(str): The color map to use for the z-axis.
            label(str): The label of the curve.
            validate(bool): If True, validate the device names and entries.
            dap(str): The dap model to use for the curve. If not specified, none will be added.

        Returns:
            BECCurve: The curve object.
        """

    @rpc_call
    def add_dap(
        self,
        x_name: "str",
        y_name: "str",
        x_entry: "str | None" = None,
        y_entry: "str | None" = None,
        color: "str | None" = None,
        dap: "str" = "GaussianModel",
        validate_bec: "bool" = True,
        **kwargs,
    ) -> "BECCurve":
        """
        Add LMFIT dap model curve to the plot widget.

        Args:
            x_name(str): Name of the x signal.
            x_entry(str): Entry of the x signal.
            y_name(str): Name of the y signal.
            y_entry(str): Entry of the y signal.
            color(str, optional): Color of the curve. Defaults to None.
            dap(str): The dap model to use for the curve.
            validate_bec(bool, optional): If True, validate the signal with BEC. Defaults to True.
            **kwargs: Additional keyword arguments for the curve configuration.

        Returns:
            BECCurve: The curve object.
        """

    @rpc_call
    def get_dap_params(self) -> "dict":
        """
        Get the DAP parameters of all DAP curves.

        Returns:
            dict: DAP parameters of all DAP curves.
        """

    @rpc_call
    def remove_curve(self, *identifiers):
        """
        Remove a curve from the plot widget.

        Args:
            *identifiers: Identifier of the curve to be removed. Can be either an integer (index) or a string (curve_id).
        """

    @rpc_call
    def scan_history(self, scan_index: "int" = None, scan_id: "str" = None):
        """
        Update the scan curves with the data from the scan storage.
        Provide only one of scan_id or scan_index.

        Args:
            scan_id(str, optional): ScanID of the scan to be updated. Defaults to None.
            scan_index(int, optional): Index of the scan to be updated. Defaults to None.
        """

    @rpc_call
    def get_all_data(self, output: "Literal['dict', 'pandas']" = "dict") -> "dict | pd.DataFrame":
        """
        Extract all curve data into a dictionary or a pandas DataFrame.

        Args:
            output (Literal["dict", "pandas"]): Format of the output data.

        Returns:
            dict | pd.DataFrame: Data of all curves in the specified format.
        """

    @rpc_call
    def set(self, **kwargs):
        """
        Set the properties of the plot widget.

        Args:
            **kwargs: Keyword arguments for the properties to be set.

        Possible properties:
            - title: str
            - x_label: str
            - y_label: str
            - x_scale: Literal["linear", "log"]
            - y_scale: Literal["linear", "log"]
            - x_lim: tuple
            - y_lim: tuple
            - legend_label_size: int
        """

    @rpc_call
    def set_x(self, x_name: "str", x_entry: "str | None" = None):
        """
        Change the x axis of the plot widget.

        Args:
            x_name(str): Name of the x signal.
                - "best_effort": Use the best effort signal.
                - "timestamp": Use the timestamp signal.
                - "index": Use the index signal.
                - Custom signal name of device from BEC.
            x_entry(str): Entry of the x signal.
        """

    @rpc_call
    def set_title(self, title: "str"):
        """
        Set the title of the plot widget.

        Args:
            title(str): Title of the plot.
        """

    @rpc_call
    def set_x_label(self, x_label: "str"):
        """
        Set the x-axis label of the plot widget.

        Args:
            x_label(str): Label of the x-axis.
        """

    @rpc_call
    def set_y_label(self, y_label: "str"):
        """
        Set the y-axis label of the plot widget.

        Args:
            y_label(str): Label of the y-axis.
        """

    @rpc_call
    def set_x_scale(self, x_scale: "Literal['linear', 'log']"):
        """
        Set the scale of the x-axis of the plot widget.

        Args:
            x_scale(Literal["linear", "log"]): Scale of the x-axis.
        """

    @rpc_call
    def set_y_scale(self, y_scale: "Literal['linear', 'log']"):
        """
        Set the scale of the y-axis of the plot widget.

        Args:
            y_scale(Literal["linear", "log"]): Scale of the y-axis.
        """

    @rpc_call
    def set_x_lim(self, x_lim: "tuple"):
        """
        Set the limits of the x-axis of the plot widget.

        Args:
            x_lim(tuple): Limits of the x-axis.
        """

    @rpc_call
    def set_y_lim(self, y_lim: "tuple"):
        """
        Set the limits of the y-axis of the plot widget.

        Args:
            y_lim(tuple): Limits of the y-axis.
        """

    @rpc_call
    def set_legend_label_size(self, legend_label_size: "int"):
        """
        Set the size of the legend labels of the plot widget.

        Args:
            legend_label_size(int): Size of the legend labels.
        """

    @rpc_call
    def set_auto_range(self, enabled: "bool", axis: "str" = "xy"):
        """
        Set the auto range of the plot widget.

        Args:
            enabled(bool): If True, enable the auto range.
            axis(str, optional): The axis to enable the auto range.
                - "xy": Enable auto range for both x and y axis.
                - "x": Enable auto range for x axis.
                - "y": Enable auto range for y axis.
        """

    @rpc_call
    def set_grid(self, x_grid: "bool", y_grid: "bool"):
        """
        Set the grid visibility of the plot widget.

        Args:
            x_grid(bool): Visibility of the x-axis grid.
            y_grid(bool): Visibility of the y-axis grid.
        """

    @rpc_call
    def lock_aspect_ratio(self, lock: "bool"):
        """
        Lock the aspect ratio of the plot widget.

        Args:
            lock(bool): Lock the aspect ratio.
        """

    @rpc_call
    def export(self):
        """
        Show the export dialog for the plot widget.
        """

    @rpc_call
    def export_to_matplotlib(self):
        """
        Export the plot widget to Matplotlib.
        """


class DeviceBox(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """


class DeviceComboBox(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """


class DeviceInputBase(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """


class DeviceLineEdit(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """


class Ring(RPCBase):
    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """

    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def set_value(self, value: "int | float"):
        """
        Set the value for the ring widget

        Args:
            value(int | float): Value for the ring widget
        """

    @rpc_call
    def set_color(self, color: "str | tuple"):
        """
        Set the color for the ring widget

        Args:
            color(str | tuple): Color for the ring widget. Can be HEX code or tuple (R, G, B, A).
        """

    @rpc_call
    def set_background(self, color: "str | tuple"):
        """
        Set the background color for the ring widget

        Args:
            color(str | tuple): Background color for the ring widget. Can be HEX code or tuple (R, G, B, A).
        """

    @rpc_call
    def set_line_width(self, width: "int"):
        """
        Set the line width for the ring widget

        Args:
            width(int): Line width for the ring widget
        """

    @rpc_call
    def set_min_max_values(self, min_value: "int | float", max_value: "int | float"):
        """
        Set the min and max values for the ring widget.

        Args:
            min_value(int | float): Minimum value for the ring widget
            max_value(int | float): Maximum value for the ring widget
        """

    @rpc_call
    def set_start_angle(self, start_angle: "int"):
        """
        Set the start angle for the ring widget

        Args:
            start_angle(int): Start angle for the ring widget in degrees
        """

    @rpc_call
    def set_update(self, mode: "Literal['manual', 'scan', 'device']", device: "str" = None):
        """
        Set the update mode for the ring widget.
        Modes:
        - "manual": Manual update mode, the value is set by the user.
        - "scan": Update mode for the scan progress. The value is updated by the current scan progress.
        - "device": Update mode for the device readback. The value is updated by the device readback. Take into account that user has to set the device name and limits.

        Args:
            mode(str): Update mode for the ring widget. Can be "manual", "scan" or "device"
            device(str): Device name for the device readback mode, only used when mode is "device"
        """

    @rpc_call
    def reset_connection(self):
        """
        Reset the connections for the ring widget. Disconnect the current slot and endpoint.
        """


class RingProgressBar(RPCBase):
    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """

    @property
    @rpc_call
    def _rpc_id(self) -> "str":
        """
        Get the RPC ID of the widget.
        """

    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @property
    @rpc_call
    def rings(self):
        """
        None
        """

    @rpc_call
    def update_config(self, config: "RingProgressBarConfig | dict"):
        """
        Update the configuration of the widget.

        Args:
            config(SpiralProgressBarConfig|dict): Configuration to update.
        """

    @rpc_call
    def add_ring(self, **kwargs) -> "Ring":
        """
        Add a new progress bar.

        Args:
            **kwargs: Keyword arguments for the new progress bar.

        Returns:
            Ring: Ring object.
        """

    @rpc_call
    def remove_ring(self, index: "int"):
        """
        Remove a progress bar by index.

        Args:
            index(int): Index of the progress bar to remove.
        """

    @rpc_call
    def set_precision(self, precision: "int", bar_index: "int" = None):
        """
        Set the precision for the progress bars. If bar_index is not provide, the precision will be set for all progress bars.

        Args:
            precision(int): Precision for the progress bars.
            bar_index(int): Index of the progress bar to set the precision for. If provided, only a single precision can be set.
        """

    @rpc_call
    def set_min_max_values(
        self,
        min_values: "int | float | list[int | float]",
        max_values: "int | float | list[int | float]",
    ):
        """
        Set the minimum and maximum values for the progress bars.

        Args:
            min_values(int|float | list[float]): Minimum value(s) for the progress bars. If multiple progress bars are displayed, provide a list of minimum values for each progress bar.
            max_values(int|float | list[float]): Maximum value(s) for the progress bars. If multiple progress bars are displayed, provide a list of maximum values for each progress bar.
        """

    @rpc_call
    def set_number_of_bars(self, num_bars: "int"):
        """
        Set the number of progress bars to display.

        Args:
            num_bars(int): Number of progress bars to display.
        """

    @rpc_call
    def set_value(self, values: "int | list", ring_index: "int" = None):
        """
        Set the values for the progress bars.

        Args:
            values(int | tuple): Value(s) for the progress bars. If multiple progress bars are displayed, provide a tuple of values for each progress bar.
            ring_index(int): Index of the progress bar to set the value for. If provided, only a single value can be set.

        Examples:
            >>> SpiralProgressBar.set_value(50)
            >>> SpiralProgressBar.set_value([30, 40, 50]) # (outer, middle, inner)
            >>> SpiralProgressBar.set_value(60, bar_index=1) # Set the value for the middle progress bar.
        """

    @rpc_call
    def set_colors_from_map(self, colormap, color_format: "Literal['RGB', 'HEX']" = "RGB"):
        """
        Set the colors for the progress bars from a colormap.

        Args:
            colormap(str): Name of the colormap.
            color_format(Literal["RGB","HEX"]): Format of the returned colors ('RGB', 'HEX').
        """

    @rpc_call
    def set_colors_directly(
        self, colors: "list[str | tuple] | str | tuple", bar_index: "int" = None
    ):
        """
        Set the colors for the progress bars directly.

        Args:
            colors(list[str | tuple] | str | tuple): Color(s) for the progress bars. If multiple progress bars are displayed, provide a list of colors for each progress bar.
            bar_index(int): Index of the progress bar to set the color for. If provided, only a single color can be set.
        """

    @rpc_call
    def set_line_widths(self, widths: "int | list[int]", bar_index: "int" = None):
        """
        Set the line widths for the progress bars.

        Args:
            widths(int | list[int]): Line width(s) for the progress bars. If multiple progress bars are displayed, provide a list of line widths for each progress bar.
            bar_index(int): Index of the progress bar to set the line width for. If provided, only a single line width can be set.
        """

    @rpc_call
    def set_gap(self, gap: "int"):
        """
        Set the gap between the progress bars.

        Args:
            gap(int): Gap between the progress bars.
        """

    @rpc_call
    def set_diameter(self, diameter: "int"):
        """
        Set the diameter of the widget.

        Args:
            diameter(int): Diameter of the widget.
        """

    @rpc_call
    def reset_diameter(self):
        """
        Reset the fixed size of the widget.
        """

    @rpc_call
    def enable_auto_updates(self, enable: "bool" = True):
        """
        Enable or disable updates based on scan status. Overrides manual updates.
        The behaviour of the whole progress bar widget will be driven by the scan queue status.

        Args:
            enable(bool): True or False.

        Returns:
            bool: True if scan segment updates are enabled.
        """


class ScanControl(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """


class StopButton(RPCBase):
    @property
    @rpc_call
    def _config_dict(self) -> "dict":
        """
        Get the configuration of the widget.

        Returns:
            dict: The configuration of the widget.
        """

    @rpc_call
    def _get_all_rpc(self) -> "dict":
        """
        Get all registered RPC objects.
        """


class TextBox(RPCBase):
    @rpc_call
    def set_color(self, background_color: str, font_color: str) -> None:
        """
        Set the background color of the widget.

        Args:
            background_color (str): The color to set the background in HEX.
            font_color (str): The color to set the font in HEX.
        """

    @rpc_call
    def set_text(self, text: str) -> None:
        """
        Set the text of the widget.

        Args:
            text (str): The text to set.
        """

    @rpc_call
    def set_font_size(self, size: int) -> None:
        """
        Set the font size of the text in the widget.

        Args:
            size (int): The font size to set.
        """


class VSCodeEditor(RPCBase): ...


class WebsiteWidget(RPCBase):
    @rpc_call
    def set_url(self, url: str) -> None:
        """
        Set the url of the website widget

        Args:
            url (str): The url to set
        """

    @rpc_call
    def get_url(self) -> str:
        """
        Get the current url of the website widget

        Returns:
            str: The current url
        """

    @rpc_call
    def reload(self):
        """
        Reload the website
        """

    @rpc_call
    def back(self):
        """
        Go back in the history
        """

    @rpc_call
    def forward(self):
        """
        Go forward in the history
        """
