"""Add strategy and strategy_preset tables

Revision ID: 0e6547a3ccf0
Revises: c1ceaae14e9f
Create Date: 2025-08-05 08:20:13.498194

"""

from collections.abc import Sequence

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "0e6547a3ccf0"
down_revision: str | Sequence[str] | None = "c1ceaae14e9f"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "strategies",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("class_name", sa.String(), nullable=False),
        sa.Column("module_path", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("category", sa.String(), nullable=True),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_strategies_name"), "strategies", ["name"], unique=True)
    op.create_table(
        "strategy_presets",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("strategy_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("parameters_json", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("is_default", sa.Boolean(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["strategy_id"],
            ["strategies.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("strategy_id", "name", name="unique_strategy_preset"),
    )
    op.create_index(op.f("ix_strategy_presets_name"), "strategy_presets", ["name"], unique=False)
    op.create_index(op.f("ix_strategy_presets_strategy_id"), "strategy_presets", ["strategy_id"], unique=False)
    op.drop_index(op.f("idx_dividends_date"), table_name="dividends")
    op.drop_index(op.f("idx_options_calls_symbol_exp_strike"), table_name="options_calls")
    op.drop_index(op.f("idx_options_puts_symbol_exp_strike"), table_name="options_puts")
    op.drop_index(op.f("idx_price_history_date"), table_name="price_history")
    op.drop_index(op.f("idx_price_history_symbol_date_interval"), table_name="price_history")
    op.drop_index(op.f("idx_price_history_symbol_interval"), table_name="price_history")
    op.drop_index(op.f("idx_splits_date"), table_name="splits")
    op.drop_index(op.f("idx_stock_info_symbol"), table_name="stock_info")
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(op.f("idx_stock_info_symbol"), "stock_info", ["symbol"], unique=False)
    op.create_index(op.f("idx_splits_date"), "splits", ["date"], unique=False)
    op.create_index(op.f("idx_price_history_symbol_interval"), "price_history", ["symbol", "interval"], unique=False)
    op.create_index(
        op.f("idx_price_history_symbol_date_interval"), "price_history", ["symbol", "date", "interval"], unique=False
    )
    op.create_index(op.f("idx_price_history_date"), "price_history", ["date"], unique=False)
    op.create_index(
        op.f("idx_options_puts_symbol_exp_strike"),
        "options_puts",
        ["symbol", "expiration_date", "strike"],
        unique=False,
    )
    op.create_index(
        op.f("idx_options_calls_symbol_exp_strike"),
        "options_calls",
        ["symbol", "expiration_date", "strike"],
        unique=False,
    )
    op.create_index(op.f("idx_dividends_date"), "dividends", ["date"], unique=False)
    op.drop_index(op.f("ix_strategy_presets_strategy_id"), table_name="strategy_presets")
    op.drop_index(op.f("ix_strategy_presets_name"), table_name="strategy_presets")
    op.drop_table("strategy_presets")
    op.drop_index(op.f("ix_strategies_name"), table_name="strategies")
    op.drop_table("strategies")
    # ### end Alembic commands ###
