# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppSecMalwarePolicyActionArgs', 'AppSecMalwarePolicyAction']

@pulumi.input_type
class AppSecMalwarePolicyActionArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 config_id: pulumi.Input[_builtins.int],
                 malware_policy_id: pulumi.Input[_builtins.int],
                 security_policy_id: pulumi.Input[_builtins.str],
                 unscanned_action: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a AppSecMalwarePolicyAction resource.
        :param pulumi.Input[_builtins.str] action: Action to be taken for requests scanned according to the malware policy
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.int] malware_policy_id: Unique identifier of the malware policy
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[_builtins.str] unscanned_action: Action to be taken for requests not scanned according to the malware policy
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "malware_policy_id", malware_policy_id)
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        pulumi.set(__self__, "unscanned_action", unscanned_action)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Action to be taken for requests scanned according to the malware policy
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="malwarePolicyId")
    def malware_policy_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the malware policy
        """
        return pulumi.get(self, "malware_policy_id")

    @malware_policy_id.setter
    def malware_policy_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "malware_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="unscannedAction")
    def unscanned_action(self) -> pulumi.Input[_builtins.str]:
        """
        Action to be taken for requests not scanned according to the malware policy
        """
        return pulumi.get(self, "unscanned_action")

    @unscanned_action.setter
    def unscanned_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "unscanned_action", value)


@pulumi.input_type
class _AppSecMalwarePolicyActionState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 malware_policy_id: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unscanned_action: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppSecMalwarePolicyAction resources.
        :param pulumi.Input[_builtins.str] action: Action to be taken for requests scanned according to the malware policy
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.int] malware_policy_id: Unique identifier of the malware policy
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[_builtins.str] unscanned_action: Action to be taken for requests not scanned according to the malware policy
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if malware_policy_id is not None:
            pulumi.set(__self__, "malware_policy_id", malware_policy_id)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if unscanned_action is not None:
            pulumi.set(__self__, "unscanned_action", unscanned_action)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be taken for requests scanned according to the malware policy
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="malwarePolicyId")
    def malware_policy_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the malware policy
        """
        return pulumi.get(self, "malware_policy_id")

    @malware_policy_id.setter
    def malware_policy_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "malware_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="unscannedAction")
    def unscanned_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be taken for requests not scanned according to the malware policy
        """
        return pulumi.get(self, "unscanned_action")

    @unscanned_action.setter
    def unscanned_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unscanned_action", value)


@pulumi.type_token("akamai:index/appSecMalwarePolicyAction:AppSecMalwarePolicyAction")
class AppSecMalwarePolicyAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 malware_policy_id: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unscanned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a AppSecMalwarePolicyAction resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action to be taken for requests scanned according to the malware policy
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.int] malware_policy_id: Unique identifier of the malware policy
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[_builtins.str] unscanned_action: Action to be taken for requests not scanned according to the malware policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecMalwarePolicyActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecMalwarePolicyAction resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecMalwarePolicyActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecMalwarePolicyActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 malware_policy_id: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 unscanned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecMalwarePolicyActionArgs.__new__(AppSecMalwarePolicyActionArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            if malware_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'malware_policy_id'")
            __props__.__dict__["malware_policy_id"] = malware_policy_id
            if security_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy_id'")
            __props__.__dict__["security_policy_id"] = security_policy_id
            if unscanned_action is None and not opts.urn:
                raise TypeError("Missing required property 'unscanned_action'")
            __props__.__dict__["unscanned_action"] = unscanned_action
        super(AppSecMalwarePolicyAction, __self__).__init__(
            'akamai:index/appSecMalwarePolicyAction:AppSecMalwarePolicyAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            malware_policy_id: Optional[pulumi.Input[_builtins.int]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            unscanned_action: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppSecMalwarePolicyAction':
        """
        Get an existing AppSecMalwarePolicyAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action to be taken for requests scanned according to the malware policy
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.int] malware_policy_id: Unique identifier of the malware policy
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[_builtins.str] unscanned_action: Action to be taken for requests not scanned according to the malware policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecMalwarePolicyActionState.__new__(_AppSecMalwarePolicyActionState)

        __props__.__dict__["action"] = action
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["malware_policy_id"] = malware_policy_id
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["unscanned_action"] = unscanned_action
        return AppSecMalwarePolicyAction(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        Action to be taken for requests scanned according to the malware policy
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="malwarePolicyId")
    def malware_policy_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the malware policy
        """
        return pulumi.get(self, "malware_policy_id")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter(name="unscannedAction")
    def unscanned_action(self) -> pulumi.Output[_builtins.str]:
        """
        Action to be taken for requests not scanned according to the malware policy
        """
        return pulumi.get(self, "unscanned_action")

