# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AppSecSlowPostArgs', 'AppSecSlowPost']

@pulumi.input_type
class AppSecSlowPostArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[_builtins.int],
                 security_policy_id: pulumi.Input[_builtins.str],
                 slow_rate_action: pulumi.Input[_builtins.str],
                 duration_threshold_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_rate_threshold_period: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_rate_threshold_rate: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a AppSecSlowPost resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[_builtins.str] slow_rate_action: Action to be taken when slow POST protection is triggered
        :param pulumi.Input[_builtins.int] duration_threshold_timeout: Maximum amount of time (in seconds) within which the first 8KB of the POST body must be received to avoid triggering the
               specified action
        :param pulumi.Input[_builtins.int] slow_rate_threshold_period: Amount of time (in seconds) that the server should allow a request before marking the request as being too slow
        :param pulumi.Input[_builtins.int] slow_rate_threshold_rate: Average rate (in bytes per second over the specified time period) allowed before the specified action is triggered
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        pulumi.set(__self__, "slow_rate_action", slow_rate_action)
        if duration_threshold_timeout is not None:
            pulumi.set(__self__, "duration_threshold_timeout", duration_threshold_timeout)
        if slow_rate_threshold_period is not None:
            pulumi.set(__self__, "slow_rate_threshold_period", slow_rate_threshold_period)
        if slow_rate_threshold_rate is not None:
            pulumi.set(__self__, "slow_rate_threshold_rate", slow_rate_threshold_rate)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="slowRateAction")
    def slow_rate_action(self) -> pulumi.Input[_builtins.str]:
        """
        Action to be taken when slow POST protection is triggered
        """
        return pulumi.get(self, "slow_rate_action")

    @slow_rate_action.setter
    def slow_rate_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "slow_rate_action", value)

    @_builtins.property
    @pulumi.getter(name="durationThresholdTimeout")
    def duration_threshold_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum amount of time (in seconds) within which the first 8KB of the POST body must be received to avoid triggering the
        specified action
        """
        return pulumi.get(self, "duration_threshold_timeout")

    @duration_threshold_timeout.setter
    def duration_threshold_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration_threshold_timeout", value)

    @_builtins.property
    @pulumi.getter(name="slowRateThresholdPeriod")
    def slow_rate_threshold_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time (in seconds) that the server should allow a request before marking the request as being too slow
        """
        return pulumi.get(self, "slow_rate_threshold_period")

    @slow_rate_threshold_period.setter
    def slow_rate_threshold_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slow_rate_threshold_period", value)

    @_builtins.property
    @pulumi.getter(name="slowRateThresholdRate")
    def slow_rate_threshold_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Average rate (in bytes per second over the specified time period) allowed before the specified action is triggered
        """
        return pulumi.get(self, "slow_rate_threshold_rate")

    @slow_rate_threshold_rate.setter
    def slow_rate_threshold_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slow_rate_threshold_rate", value)


@pulumi.input_type
class _AppSecSlowPostState:
    def __init__(__self__, *,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 duration_threshold_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_rate_action: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_rate_threshold_period: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_rate_threshold_rate: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering AppSecSlowPost resources.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.int] duration_threshold_timeout: Maximum amount of time (in seconds) within which the first 8KB of the POST body must be received to avoid triggering the
               specified action
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[_builtins.str] slow_rate_action: Action to be taken when slow POST protection is triggered
        :param pulumi.Input[_builtins.int] slow_rate_threshold_period: Amount of time (in seconds) that the server should allow a request before marking the request as being too slow
        :param pulumi.Input[_builtins.int] slow_rate_threshold_rate: Average rate (in bytes per second over the specified time period) allowed before the specified action is triggered
        """
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if duration_threshold_timeout is not None:
            pulumi.set(__self__, "duration_threshold_timeout", duration_threshold_timeout)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if slow_rate_action is not None:
            pulumi.set(__self__, "slow_rate_action", slow_rate_action)
        if slow_rate_threshold_period is not None:
            pulumi.set(__self__, "slow_rate_threshold_period", slow_rate_threshold_period)
        if slow_rate_threshold_rate is not None:
            pulumi.set(__self__, "slow_rate_threshold_rate", slow_rate_threshold_rate)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter(name="durationThresholdTimeout")
    def duration_threshold_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum amount of time (in seconds) within which the first 8KB of the POST body must be received to avoid triggering the
        specified action
        """
        return pulumi.get(self, "duration_threshold_timeout")

    @duration_threshold_timeout.setter
    def duration_threshold_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "duration_threshold_timeout", value)

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="slowRateAction")
    def slow_rate_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be taken when slow POST protection is triggered
        """
        return pulumi.get(self, "slow_rate_action")

    @slow_rate_action.setter
    def slow_rate_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slow_rate_action", value)

    @_builtins.property
    @pulumi.getter(name="slowRateThresholdPeriod")
    def slow_rate_threshold_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time (in seconds) that the server should allow a request before marking the request as being too slow
        """
        return pulumi.get(self, "slow_rate_threshold_period")

    @slow_rate_threshold_period.setter
    def slow_rate_threshold_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slow_rate_threshold_period", value)

    @_builtins.property
    @pulumi.getter(name="slowRateThresholdRate")
    def slow_rate_threshold_rate(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Average rate (in bytes per second over the specified time period) allowed before the specified action is triggered
        """
        return pulumi.get(self, "slow_rate_threshold_rate")

    @slow_rate_threshold_rate.setter
    def slow_rate_threshold_rate(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slow_rate_threshold_rate", value)


@pulumi.type_token("akamai:index/appSecSlowPost:AppSecSlowPost")
class AppSecSlowPost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 duration_threshold_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_rate_action: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_rate_threshold_period: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_rate_threshold_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a AppSecSlowPost resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.int] duration_threshold_timeout: Maximum amount of time (in seconds) within which the first 8KB of the POST body must be received to avoid triggering the
               specified action
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[_builtins.str] slow_rate_action: Action to be taken when slow POST protection is triggered
        :param pulumi.Input[_builtins.int] slow_rate_threshold_period: Amount of time (in seconds) that the server should allow a request before marking the request as being too slow
        :param pulumi.Input[_builtins.int] slow_rate_threshold_rate: Average rate (in bytes per second over the specified time period) allowed before the specified action is triggered
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSecSlowPostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AppSecSlowPost resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AppSecSlowPostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSecSlowPostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_id: Optional[pulumi.Input[_builtins.int]] = None,
                 duration_threshold_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_rate_action: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_rate_threshold_period: Optional[pulumi.Input[_builtins.int]] = None,
                 slow_rate_threshold_rate: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSecSlowPostArgs.__new__(AppSecSlowPostArgs)

            if config_id is None and not opts.urn:
                raise TypeError("Missing required property 'config_id'")
            __props__.__dict__["config_id"] = config_id
            __props__.__dict__["duration_threshold_timeout"] = duration_threshold_timeout
            if security_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_policy_id'")
            __props__.__dict__["security_policy_id"] = security_policy_id
            if slow_rate_action is None and not opts.urn:
                raise TypeError("Missing required property 'slow_rate_action'")
            __props__.__dict__["slow_rate_action"] = slow_rate_action
            __props__.__dict__["slow_rate_threshold_period"] = slow_rate_threshold_period
            __props__.__dict__["slow_rate_threshold_rate"] = slow_rate_threshold_rate
        super(AppSecSlowPost, __self__).__init__(
            'akamai:index/appSecSlowPost:AppSecSlowPost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_id: Optional[pulumi.Input[_builtins.int]] = None,
            duration_threshold_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            security_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            slow_rate_action: Optional[pulumi.Input[_builtins.str]] = None,
            slow_rate_threshold_period: Optional[pulumi.Input[_builtins.int]] = None,
            slow_rate_threshold_rate: Optional[pulumi.Input[_builtins.int]] = None) -> 'AppSecSlowPost':
        """
        Get an existing AppSecSlowPost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] config_id: Unique identifier of the security configuration
        :param pulumi.Input[_builtins.int] duration_threshold_timeout: Maximum amount of time (in seconds) within which the first 8KB of the POST body must be received to avoid triggering the
               specified action
        :param pulumi.Input[_builtins.str] security_policy_id: Unique identifier of the security policy
        :param pulumi.Input[_builtins.str] slow_rate_action: Action to be taken when slow POST protection is triggered
        :param pulumi.Input[_builtins.int] slow_rate_threshold_period: Amount of time (in seconds) that the server should allow a request before marking the request as being too slow
        :param pulumi.Input[_builtins.int] slow_rate_threshold_rate: Average rate (in bytes per second over the specified time period) allowed before the specified action is triggered
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSecSlowPostState.__new__(_AppSecSlowPostState)

        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["duration_threshold_timeout"] = duration_threshold_timeout
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["slow_rate_action"] = slow_rate_action
        __props__.__dict__["slow_rate_threshold_period"] = slow_rate_threshold_period
        __props__.__dict__["slow_rate_threshold_rate"] = slow_rate_threshold_rate
        return AppSecSlowPost(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier of the security configuration
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="durationThresholdTimeout")
    def duration_threshold_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum amount of time (in seconds) within which the first 8KB of the POST body must be received to avoid triggering the
        specified action
        """
        return pulumi.get(self, "duration_threshold_timeout")

    @_builtins.property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the security policy
        """
        return pulumi.get(self, "security_policy_id")

    @_builtins.property
    @pulumi.getter(name="slowRateAction")
    def slow_rate_action(self) -> pulumi.Output[_builtins.str]:
        """
        Action to be taken when slow POST protection is triggered
        """
        return pulumi.get(self, "slow_rate_action")

    @_builtins.property
    @pulumi.getter(name="slowRateThresholdPeriod")
    def slow_rate_threshold_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Amount of time (in seconds) that the server should allow a request before marking the request as being too slow
        """
        return pulumi.get(self, "slow_rate_threshold_period")

    @_builtins.property
    @pulumi.getter(name="slowRateThresholdRate")
    def slow_rate_threshold_rate(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Average rate (in bytes per second over the specified time period) allowed before the specified action is triggered
        """
        return pulumi.get(self, "slow_rate_threshold_rate")

