# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ClientlistActivationArgs', 'ClientlistActivation']

@pulumi.input_type
class ClientlistActivationArgs:
    def __init__(__self__, *,
                 list_id: pulumi.Input[_builtins.str],
                 network: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.int],
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 siebel_ticket_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClientlistActivation resource.
        :param pulumi.Input[_builtins.str] list_id: The client list unique identifier.
        :param pulumi.Input[_builtins.str] network: The network environment where you activate your client list: either STAGING or PRODUCTION.
        :param pulumi.Input[_builtins.int] version: The client list version.
        :param pulumi.Input[_builtins.str] comments: A brief description for the activation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_recipients: Users to notify via email.
        :param pulumi.Input[_builtins.str] siebel_ticket_id: Identifies the Siebel ticket, if the activation is linked to one.
        """
        pulumi.set(__self__, "list_id", list_id)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "version", version)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if notification_recipients is not None:
            pulumi.set(__self__, "notification_recipients", notification_recipients)
        if siebel_ticket_id is not None:
            pulumi.set(__self__, "siebel_ticket_id", siebel_ticket_id)

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> pulumi.Input[_builtins.str]:
        """
        The client list unique identifier.
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "list_id", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        The network environment where you activate your client list: either STAGING or PRODUCTION.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.int]:
        """
        The client list version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A brief description for the activation.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter(name="notificationRecipients")
    def notification_recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Users to notify via email.
        """
        return pulumi.get(self, "notification_recipients")

    @notification_recipients.setter
    def notification_recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_recipients", value)

    @_builtins.property
    @pulumi.getter(name="siebelTicketId")
    def siebel_ticket_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the Siebel ticket, if the activation is linked to one.
        """
        return pulumi.get(self, "siebel_ticket_id")

    @siebel_ticket_id.setter
    def siebel_ticket_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "siebel_ticket_id", value)


@pulumi.input_type
class _ClientlistActivationState:
    def __init__(__self__, *,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 siebel_ticket_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ClientlistActivation resources.
        :param pulumi.Input[_builtins.str] comments: A brief description for the activation.
        :param pulumi.Input[_builtins.str] list_id: The client list unique identifier.
        :param pulumi.Input[_builtins.str] network: The network environment where you activate your client list: either STAGING or PRODUCTION.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_recipients: Users to notify via email.
        :param pulumi.Input[_builtins.str] siebel_ticket_id: Identifies the Siebel ticket, if the activation is linked to one.
        :param pulumi.Input[_builtins.str] status: The current activation status, either ACTIVE, INACTIVE, MODIFIED, PENDING_ACTIVATION, PENDING_DEACTIVATION, or FAILED.
        :param pulumi.Input[_builtins.int] version: The client list version.
        """
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if list_id is not None:
            pulumi.set(__self__, "list_id", list_id)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if notification_recipients is not None:
            pulumi.set(__self__, "notification_recipients", notification_recipients)
        if siebel_ticket_id is not None:
            pulumi.set(__self__, "siebel_ticket_id", siebel_ticket_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A brief description for the activation.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client list unique identifier.
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "list_id", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network environment where you activate your client list: either STAGING or PRODUCTION.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="notificationRecipients")
    def notification_recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Users to notify via email.
        """
        return pulumi.get(self, "notification_recipients")

    @notification_recipients.setter
    def notification_recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notification_recipients", value)

    @_builtins.property
    @pulumi.getter(name="siebelTicketId")
    def siebel_ticket_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the Siebel ticket, if the activation is linked to one.
        """
        return pulumi.get(self, "siebel_ticket_id")

    @siebel_ticket_id.setter
    def siebel_ticket_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "siebel_ticket_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current activation status, either ACTIVE, INACTIVE, MODIFIED, PENDING_ACTIVATION, PENDING_DEACTIVATION, or FAILED.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The client list version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("akamai:index/clientlistActivation:ClientlistActivation")
class ClientlistActivation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 siebel_ticket_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a ClientlistActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comments: A brief description for the activation.
        :param pulumi.Input[_builtins.str] list_id: The client list unique identifier.
        :param pulumi.Input[_builtins.str] network: The network environment where you activate your client list: either STAGING or PRODUCTION.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_recipients: Users to notify via email.
        :param pulumi.Input[_builtins.str] siebel_ticket_id: Identifies the Siebel ticket, if the activation is linked to one.
        :param pulumi.Input[_builtins.int] version: The client list version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientlistActivationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ClientlistActivation resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ClientlistActivationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientlistActivationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 siebel_ticket_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientlistActivationArgs.__new__(ClientlistActivationArgs)

            __props__.__dict__["comments"] = comments
            if list_id is None and not opts.urn:
                raise TypeError("Missing required property 'list_id'")
            __props__.__dict__["list_id"] = list_id
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["notification_recipients"] = notification_recipients
            __props__.__dict__["siebel_ticket_id"] = siebel_ticket_id
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["status"] = None
        super(ClientlistActivation, __self__).__init__(
            'akamai:index/clientlistActivation:ClientlistActivation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comments: Optional[pulumi.Input[_builtins.str]] = None,
            list_id: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            notification_recipients: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            siebel_ticket_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'ClientlistActivation':
        """
        Get an existing ClientlistActivation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comments: A brief description for the activation.
        :param pulumi.Input[_builtins.str] list_id: The client list unique identifier.
        :param pulumi.Input[_builtins.str] network: The network environment where you activate your client list: either STAGING or PRODUCTION.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notification_recipients: Users to notify via email.
        :param pulumi.Input[_builtins.str] siebel_ticket_id: Identifies the Siebel ticket, if the activation is linked to one.
        :param pulumi.Input[_builtins.str] status: The current activation status, either ACTIVE, INACTIVE, MODIFIED, PENDING_ACTIVATION, PENDING_DEACTIVATION, or FAILED.
        :param pulumi.Input[_builtins.int] version: The client list version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientlistActivationState.__new__(_ClientlistActivationState)

        __props__.__dict__["comments"] = comments
        __props__.__dict__["list_id"] = list_id
        __props__.__dict__["network"] = network
        __props__.__dict__["notification_recipients"] = notification_recipients
        __props__.__dict__["siebel_ticket_id"] = siebel_ticket_id
        __props__.__dict__["status"] = status
        __props__.__dict__["version"] = version
        return ClientlistActivation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A brief description for the activation.
        """
        return pulumi.get(self, "comments")

    @_builtins.property
    @pulumi.getter(name="listId")
    def list_id(self) -> pulumi.Output[_builtins.str]:
        """
        The client list unique identifier.
        """
        return pulumi.get(self, "list_id")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The network environment where you activate your client list: either STAGING or PRODUCTION.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="notificationRecipients")
    def notification_recipients(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Users to notify via email.
        """
        return pulumi.get(self, "notification_recipients")

    @_builtins.property
    @pulumi.getter(name="siebelTicketId")
    def siebel_ticket_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identifies the Siebel ticket, if the activation is linked to one.
        """
        return pulumi.get(self, "siebel_ticket_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current activation status, either ACTIVE, INACTIVE, MODIFIED, PENDING_ACTIVATION, PENDING_DEACTIVATION, or FAILED.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The client list version.
        """
        return pulumi.get(self, "version")

