# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IamCidrBlockArgs', 'IamCidrBlock']

@pulumi.input_type
class IamCidrBlockArgs:
    def __init__(__self__, *,
                 cidr_block: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 comments: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a IamCidrBlock resource.
        :param pulumi.Input[_builtins.str] cidr_block: The value of an IP address or IP address range.
        :param pulumi.Input[_builtins.bool] enabled: Enables the CIDR block on the account.
        :param pulumi.Input[_builtins.str] comments: Descriptive label you provide for the CIDR block.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "enabled", enabled)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[_builtins.str]:
        """
        The value of an IP address or IP address range.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cidr_block", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Enables the CIDR block on the account.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Descriptive label you provide for the CIDR block.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)


@pulumi.input_type
class _IamCidrBlockState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input['IamCidrBlockActionsArgs']] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 cidr_block_id: Optional[pulumi.Input[_builtins.int]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 created_date: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 modified_by: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_date: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IamCidrBlock resources.
        :param pulumi.Input['IamCidrBlockActionsArgs'] actions: Specifies activities available for the CIDR block.
        :param pulumi.Input[_builtins.str] cidr_block: The value of an IP address or IP address range.
        :param pulumi.Input[_builtins.int] cidr_block_id: Unique identifier for each CIDR block.
        :param pulumi.Input[_builtins.str] comments: Descriptive label you provide for the CIDR block.
        :param pulumi.Input[_builtins.str] created_by: The user who created the CIDR block.
        :param pulumi.Input[_builtins.str] created_date: ISO 8601 timestamp indicating when the CIDR block was created.
        :param pulumi.Input[_builtins.bool] enabled: Enables the CIDR block on the account.
        :param pulumi.Input[_builtins.str] modified_by: The user who last edited the CIDR block.
        :param pulumi.Input[_builtins.str] modified_date: ISO 8601 timestamp indicating when the CIDR block was last modified.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if cidr_block_id is not None:
            pulumi.set(__self__, "cidr_block_id", cidr_block_id)
        if comments is not None:
            pulumi.set(__self__, "comments", comments)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_date is not None:
            pulumi.set(__self__, "created_date", created_date)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if modified_by is not None:
            pulumi.set(__self__, "modified_by", modified_by)
        if modified_date is not None:
            pulumi.set(__self__, "modified_date", modified_date)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input['IamCidrBlockActionsArgs']]:
        """
        Specifies activities available for the CIDR block.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input['IamCidrBlockActionsArgs']]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value of an IP address or IP address range.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="cidrBlockId")
    def cidr_block_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Unique identifier for each CIDR block.
        """
        return pulumi.get(self, "cidr_block_id")

    @cidr_block_id.setter
    def cidr_block_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cidr_block_id", value)

    @_builtins.property
    @pulumi.getter
    def comments(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Descriptive label you provide for the CIDR block.
        """
        return pulumi.get(self, "comments")

    @comments.setter
    def comments(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comments", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user who created the CIDR block.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ISO 8601 timestamp indicating when the CIDR block was created.
        """
        return pulumi.get(self, "created_date")

    @created_date.setter
    def created_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_date", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables the CIDR block on the account.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user who last edited the CIDR block.
        """
        return pulumi.get(self, "modified_by")

    @modified_by.setter
    def modified_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_by", value)

    @_builtins.property
    @pulumi.getter(name="modifiedDate")
    def modified_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ISO 8601 timestamp indicating when the CIDR block was last modified.
        """
        return pulumi.get(self, "modified_date")

    @modified_date.setter
    def modified_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_date", value)


@pulumi.type_token("akamai:index/iamCidrBlock:IamCidrBlock")
class IamCidrBlock(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Create a IamCidrBlock resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cidr_block: The value of an IP address or IP address range.
        :param pulumi.Input[_builtins.str] comments: Descriptive label you provide for the CIDR block.
        :param pulumi.Input[_builtins.bool] enabled: Enables the CIDR block on the account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IamCidrBlockArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a IamCidrBlock resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param IamCidrBlockArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IamCidrBlockArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 comments: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IamCidrBlockArgs.__new__(IamCidrBlockArgs)

            if cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'cidr_block'")
            __props__.__dict__["cidr_block"] = cidr_block
            __props__.__dict__["comments"] = comments
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["actions"] = None
            __props__.__dict__["cidr_block_id"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["created_date"] = None
            __props__.__dict__["modified_by"] = None
            __props__.__dict__["modified_date"] = None
        super(IamCidrBlock, __self__).__init__(
            'akamai:index/iamCidrBlock:IamCidrBlock',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Union['IamCidrBlockActionsArgs', 'IamCidrBlockActionsArgsDict']]] = None,
            cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
            cidr_block_id: Optional[pulumi.Input[_builtins.int]] = None,
            comments: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            created_date: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            modified_by: Optional[pulumi.Input[_builtins.str]] = None,
            modified_date: Optional[pulumi.Input[_builtins.str]] = None) -> 'IamCidrBlock':
        """
        Get an existing IamCidrBlock resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IamCidrBlockActionsArgs', 'IamCidrBlockActionsArgsDict']] actions: Specifies activities available for the CIDR block.
        :param pulumi.Input[_builtins.str] cidr_block: The value of an IP address or IP address range.
        :param pulumi.Input[_builtins.int] cidr_block_id: Unique identifier for each CIDR block.
        :param pulumi.Input[_builtins.str] comments: Descriptive label you provide for the CIDR block.
        :param pulumi.Input[_builtins.str] created_by: The user who created the CIDR block.
        :param pulumi.Input[_builtins.str] created_date: ISO 8601 timestamp indicating when the CIDR block was created.
        :param pulumi.Input[_builtins.bool] enabled: Enables the CIDR block on the account.
        :param pulumi.Input[_builtins.str] modified_by: The user who last edited the CIDR block.
        :param pulumi.Input[_builtins.str] modified_date: ISO 8601 timestamp indicating when the CIDR block was last modified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IamCidrBlockState.__new__(_IamCidrBlockState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["cidr_block_id"] = cidr_block_id
        __props__.__dict__["comments"] = comments
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["created_date"] = created_date
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["modified_by"] = modified_by
        __props__.__dict__["modified_date"] = modified_date
        return IamCidrBlock(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output['outputs.IamCidrBlockActions']:
        """
        Specifies activities available for the CIDR block.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[_builtins.str]:
        """
        The value of an IP address or IP address range.
        """
        return pulumi.get(self, "cidr_block")

    @_builtins.property
    @pulumi.getter(name="cidrBlockId")
    def cidr_block_id(self) -> pulumi.Output[_builtins.int]:
        """
        Unique identifier for each CIDR block.
        """
        return pulumi.get(self, "cidr_block_id")

    @_builtins.property
    @pulumi.getter
    def comments(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Descriptive label you provide for the CIDR block.
        """
        return pulumi.get(self, "comments")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The user who created the CIDR block.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> pulumi.Output[_builtins.str]:
        """
        ISO 8601 timestamp indicating when the CIDR block was created.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables the CIDR block on the account.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="modifiedBy")
    def modified_by(self) -> pulumi.Output[_builtins.str]:
        """
        The user who last edited the CIDR block.
        """
        return pulumi.get(self, "modified_by")

    @_builtins.property
    @pulumi.getter(name="modifiedDate")
    def modified_date(self) -> pulumi.Output[_builtins.str]:
        """
        ISO 8601 timestamp indicating when the CIDR block was last modified.
        """
        return pulumi.get(self, "modified_date")

