# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PropertyArgs', 'Property']

@pulumi.input_type
class PropertyArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.str],
                 product_id: pulumi.Input[_builtins.str],
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 property_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_format: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None,
                 use_hostname_bucket: Optional[pulumi.Input[_builtins.bool]] = None,
                 version_notes: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Property resource.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[_builtins.str] property_id: Property ID
        :param pulumi.Input[_builtins.str] rule_format: Specify the rule format version (defaults to latest version available when created)
        :param pulumi.Input[_builtins.str] rules: Property Rules as JSON
        :param pulumi.Input[_builtins.bool] use_hostname_bucket: Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without
               incrementing property versions.
        :param pulumi.Input[_builtins.str] version_notes: Property version notes
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "product_id", product_id)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)
        if rule_format is not None:
            pulumi.set(__self__, "rule_format", rule_format)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if use_hostname_bucket is not None:
            pulumi.set(__self__, "use_hostname_bucket", use_hostname_bucket)
        if version_notes is not None:
            pulumi.set(__self__, "version_notes", version_notes)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        Contract ID to be assigned to the Property
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Group ID to be assigned to the Property
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[_builtins.str]:
        """
        Product ID to be assigned to the Property
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]]:
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]]):
        pulumi.set(self, "hostnames", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name to give to the Property (must be unique)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Property ID
        """
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "property_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the rule format version (defaults to latest version available when created)
        """
        return pulumi.get(self, "rule_format")

    @rule_format.setter
    def rule_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_format", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="useHostnameBucket")
    def use_hostname_bucket(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without
        incrementing property versions.
        """
        return pulumi.get(self, "use_hostname_bucket")

    @use_hostname_bucket.setter
    def use_hostname_bucket(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_hostname_bucket", value)

    @_builtins.property
    @pulumi.getter(name="versionNotes")
    def version_notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Property version notes
        """
        return pulumi.get(self, "version_notes")

    @version_notes.setter
    def version_notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_notes", value)


@pulumi.input_type
class _PropertyState:
    def __init__(__self__, *,
                 asset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]] = None,
                 latest_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 production_version: Optional[pulumi.Input[_builtins.int]] = None,
                 property_id: Optional[pulumi.Input[_builtins.str]] = None,
                 read_version: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyRuleErrorArgs']]]] = None,
                 rule_format: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_warnings: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyRuleWarningArgs']]]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None,
                 staging_version: Optional[pulumi.Input[_builtins.int]] = None,
                 use_hostname_bucket: Optional[pulumi.Input[_builtins.bool]] = None,
                 version_notes: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Property resources.
        :param pulumi.Input[_builtins.str] asset_id: ID of the property in the Identity and Access Management API.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[_builtins.int] latest_version: Property's current latest version number
        :param pulumi.Input[_builtins.str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[_builtins.str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[_builtins.int] production_version: Property's version currently activated in production (zero when not active in production)
        :param pulumi.Input[_builtins.str] property_id: Property ID
        :param pulumi.Input[_builtins.int] read_version: Required property's version to be read
        :param pulumi.Input[_builtins.str] rule_format: Specify the rule format version (defaults to latest version available when created)
        :param pulumi.Input[Sequence[pulumi.Input['PropertyRuleWarningArgs']]] rule_warnings: Rule validation warnings
        :param pulumi.Input[_builtins.str] rules: Property Rules as JSON
        :param pulumi.Input[_builtins.int] staging_version: Property's version currently activated in staging (zero when not active in staging)
        :param pulumi.Input[_builtins.bool] use_hostname_bucket: Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without
               incrementing property versions.
        :param pulumi.Input[_builtins.str] version_notes: Property version notes
        """
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if production_version is not None:
            pulumi.set(__self__, "production_version", production_version)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)
        if read_version is not None:
            pulumi.set(__self__, "read_version", read_version)
        if rule_errors is not None:
            pulumi.set(__self__, "rule_errors", rule_errors)
        if rule_format is not None:
            pulumi.set(__self__, "rule_format", rule_format)
        if rule_warnings is not None:
            pulumi.set(__self__, "rule_warnings", rule_warnings)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if staging_version is not None:
            pulumi.set(__self__, "staging_version", staging_version)
        if use_hostname_bucket is not None:
            pulumi.set(__self__, "use_hostname_bucket", use_hostname_bucket)
        if version_notes is not None:
            pulumi.set(__self__, "version_notes", version_notes)

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the property in the Identity and Access Management API.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "asset_id", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contract ID to be assigned to the Property
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Group ID to be assigned to the Property
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]]:
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyHostnameArgs']]]]):
        pulumi.set(self, "hostnames", value)

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Property's current latest version number
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "latest_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name to give to the Property (must be unique)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Product ID to be assigned to the Property
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="productionVersion")
    def production_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Property's version currently activated in production (zero when not active in production)
        """
        return pulumi.get(self, "production_version")

    @production_version.setter
    def production_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "production_version", value)

    @_builtins.property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Property ID
        """
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "property_id", value)

    @_builtins.property
    @pulumi.getter(name="readVersion")
    def read_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Required property's version to be read
        """
        return pulumi.get(self, "read_version")

    @read_version.setter
    def read_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_version", value)

    @_builtins.property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PropertyRuleErrorArgs']]]]:
        return pulumi.get(self, "rule_errors")

    @rule_errors.setter
    def rule_errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyRuleErrorArgs']]]]):
        pulumi.set(self, "rule_errors", value)

    @_builtins.property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the rule format version (defaults to latest version available when created)
        """
        return pulumi.get(self, "rule_format")

    @rule_format.setter
    def rule_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_format", value)

    @_builtins.property
    @pulumi.getter(name="ruleWarnings")
    def rule_warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PropertyRuleWarningArgs']]]]:
        """
        Rule validation warnings
        """
        return pulumi.get(self, "rule_warnings")

    @rule_warnings.setter
    def rule_warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PropertyRuleWarningArgs']]]]):
        pulumi.set(self, "rule_warnings", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="stagingVersion")
    def staging_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Property's version currently activated in staging (zero when not active in staging)
        """
        return pulumi.get(self, "staging_version")

    @staging_version.setter
    def staging_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "staging_version", value)

    @_builtins.property
    @pulumi.getter(name="useHostnameBucket")
    def use_hostname_bucket(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without
        incrementing property versions.
        """
        return pulumi.get(self, "use_hostname_bucket")

    @use_hostname_bucket.setter
    def use_hostname_bucket(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_hostname_bucket", value)

    @_builtins.property
    @pulumi.getter(name="versionNotes")
    def version_notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Property version notes
        """
        return pulumi.get(self, "version_notes")

    @version_notes.setter
    def version_notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_notes", value)


@pulumi.type_token("akamai:index/property:Property")
class Property(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PropertyHostnameArgs', 'PropertyHostnameArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 property_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_format: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None,
                 use_hostname_bucket: Optional[pulumi.Input[_builtins.bool]] = None,
                 version_notes: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Property resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[_builtins.str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] property_id: Property ID
        :param pulumi.Input[_builtins.str] rule_format: Specify the rule format version (defaults to latest version available when created)
        :param pulumi.Input[_builtins.str] rules: Property Rules as JSON
        :param pulumi.Input[_builtins.bool] use_hostname_bucket: Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without
               incrementing property versions.
        :param pulumi.Input[_builtins.str] version_notes: Property version notes
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PropertyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Property resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PropertyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PropertyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PropertyHostnameArgs', 'PropertyHostnameArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 property_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_format: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None,
                 use_hostname_bucket: Optional[pulumi.Input[_builtins.bool]] = None,
                 version_notes: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PropertyArgs.__new__(PropertyArgs)

            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["hostnames"] = hostnames
            __props__.__dict__["name"] = name
            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["property_id"] = property_id
            __props__.__dict__["rule_format"] = rule_format
            __props__.__dict__["rules"] = rules
            __props__.__dict__["use_hostname_bucket"] = use_hostname_bucket
            __props__.__dict__["version_notes"] = version_notes
            __props__.__dict__["asset_id"] = None
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["production_version"] = None
            __props__.__dict__["read_version"] = None
            __props__.__dict__["rule_errors"] = None
            __props__.__dict__["rule_warnings"] = None
            __props__.__dict__["staging_version"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="akamai:properties/property:Property")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Property, __self__).__init__(
            'akamai:index/property:Property',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            asset_id: Optional[pulumi.Input[_builtins.str]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PropertyHostnameArgs', 'PropertyHostnameArgsDict']]]]] = None,
            latest_version: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            product_id: Optional[pulumi.Input[_builtins.str]] = None,
            production_version: Optional[pulumi.Input[_builtins.int]] = None,
            property_id: Optional[pulumi.Input[_builtins.str]] = None,
            read_version: Optional[pulumi.Input[_builtins.int]] = None,
            rule_errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PropertyRuleErrorArgs', 'PropertyRuleErrorArgsDict']]]]] = None,
            rule_format: Optional[pulumi.Input[_builtins.str]] = None,
            rule_warnings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PropertyRuleWarningArgs', 'PropertyRuleWarningArgsDict']]]]] = None,
            rules: Optional[pulumi.Input[_builtins.str]] = None,
            staging_version: Optional[pulumi.Input[_builtins.int]] = None,
            use_hostname_bucket: Optional[pulumi.Input[_builtins.bool]] = None,
            version_notes: Optional[pulumi.Input[_builtins.str]] = None) -> 'Property':
        """
        Get an existing Property resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] asset_id: ID of the property in the Identity and Access Management API.
        :param pulumi.Input[_builtins.str] contract_id: Contract ID to be assigned to the Property
        :param pulumi.Input[_builtins.str] group_id: Group ID to be assigned to the Property
        :param pulumi.Input[_builtins.int] latest_version: Property's current latest version number
        :param pulumi.Input[_builtins.str] name: Name to give to the Property (must be unique)
        :param pulumi.Input[_builtins.str] product_id: Product ID to be assigned to the Property
        :param pulumi.Input[_builtins.int] production_version: Property's version currently activated in production (zero when not active in production)
        :param pulumi.Input[_builtins.str] property_id: Property ID
        :param pulumi.Input[_builtins.int] read_version: Required property's version to be read
        :param pulumi.Input[_builtins.str] rule_format: Specify the rule format version (defaults to latest version available when created)
        :param pulumi.Input[Sequence[pulumi.Input[Union['PropertyRuleWarningArgs', 'PropertyRuleWarningArgsDict']]]] rule_warnings: Rule validation warnings
        :param pulumi.Input[_builtins.str] rules: Property Rules as JSON
        :param pulumi.Input[_builtins.int] staging_version: Property's version currently activated in staging (zero when not active in staging)
        :param pulumi.Input[_builtins.bool] use_hostname_bucket: Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without
               incrementing property versions.
        :param pulumi.Input[_builtins.str] version_notes: Property version notes
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PropertyState.__new__(_PropertyState)

        __props__.__dict__["asset_id"] = asset_id
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["hostnames"] = hostnames
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["name"] = name
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["production_version"] = production_version
        __props__.__dict__["property_id"] = property_id
        __props__.__dict__["read_version"] = read_version
        __props__.__dict__["rule_errors"] = rule_errors
        __props__.__dict__["rule_format"] = rule_format
        __props__.__dict__["rule_warnings"] = rule_warnings
        __props__.__dict__["rules"] = rules
        __props__.__dict__["staging_version"] = staging_version
        __props__.__dict__["use_hostname_bucket"] = use_hostname_bucket
        __props__.__dict__["version_notes"] = version_notes
        return Property(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the property in the Identity and Access Management API.
        """
        return pulumi.get(self, "asset_id")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        Contract ID to be assigned to the Property
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Group ID to be assigned to the Property
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> pulumi.Output[Optional[Sequence['outputs.PropertyHostname']]]:
        return pulumi.get(self, "hostnames")

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[_builtins.int]:
        """
        Property's current latest version number
        """
        return pulumi.get(self, "latest_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name to give to the Property (must be unique)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[_builtins.str]:
        """
        Product ID to be assigned to the Property
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="productionVersion")
    def production_version(self) -> pulumi.Output[_builtins.int]:
        """
        Property's version currently activated in production (zero when not active in production)
        """
        return pulumi.get(self, "production_version")

    @_builtins.property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Property ID
        """
        return pulumi.get(self, "property_id")

    @_builtins.property
    @pulumi.getter(name="readVersion")
    def read_version(self) -> pulumi.Output[_builtins.int]:
        """
        Required property's version to be read
        """
        return pulumi.get(self, "read_version")

    @_builtins.property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> pulumi.Output[Sequence['outputs.PropertyRuleError']]:
        return pulumi.get(self, "rule_errors")

    @_builtins.property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the rule format version (defaults to latest version available when created)
        """
        return pulumi.get(self, "rule_format")

    @_builtins.property
    @pulumi.getter(name="ruleWarnings")
    def rule_warnings(self) -> pulumi.Output[Sequence['outputs.PropertyRuleWarning']]:
        """
        Rule validation warnings
        """
        return pulumi.get(self, "rule_warnings")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[_builtins.str]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="stagingVersion")
    def staging_version(self) -> pulumi.Output[_builtins.int]:
        """
        Property's version currently activated in staging (zero when not active in staging)
        """
        return pulumi.get(self, "staging_version")

    @_builtins.property
    @pulumi.getter(name="useHostnameBucket")
    def use_hostname_bucket(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether hostname bucket is used with this property. It allows you to add or remove property hostnames without
        incrementing property versions.
        """
        return pulumi.get(self, "use_hostname_bucket")

    @_builtins.property
    @pulumi.getter(name="versionNotes")
    def version_notes(self) -> pulumi.Output[_builtins.str]:
        """
        Property version notes
        """
        return pulumi.get(self, "version_notes")

