# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PropertyHostnameBucketArgs', 'PropertyHostnameBucket']

@pulumi.input_type
class PropertyHostnameBucketArgs:
    def __init__(__self__, *,
                 hostnames: pulumi.Input[Mapping[str, pulumi.Input['PropertyHostnameBucketHostnamesArgs']]],
                 network: pulumi.Input[_builtins.str],
                 property_id: pulumi.Input[_builtins.str],
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_count: Optional[pulumi.Input[_builtins.int]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 timeout_for_activation: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a PropertyHostnameBucket resource.
        :param pulumi.Input[Mapping[str, pulumi.Input['PropertyHostnameBucketHostnamesArgs']]] hostnames: The hostnames mapping. The key represents 'cname_from' and the value contains hostnames details, consisting of
               certificate provisioning type and edge hostname.
        :param pulumi.Input[_builtins.str] network: The network to activate on, either `STAGING` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] property_id: The unique identifier for the property.
        :param pulumi.Input[_builtins.str] contract_id: The unique identifier for the contract. Provide it if resolving the property without 'contract_id' and 'group_id' is not
               possible
        :param pulumi.Input[_builtins.str] group_id: The unique identifier for the group. Provide it if resolving the property without 'contract_id' and 'group_id' is not
               possible
        :param pulumi.Input[_builtins.int] hostname_count: The computed number of hostnames after applying desired modifications. Used only to informduring the plan phase about
               the number of hostnames that will be active after making the changes.
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_emails: Email addresses to notify when the activation status changes.
        :param pulumi.Input[_builtins.int] timeout_for_activation: The timeout value in minutes after which a single hostname activation will be canceled. Defaults to 50 minutes.
        """
        pulumi.set(__self__, "hostnames", hostnames)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "property_id", property_id)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if hostname_count is not None:
            pulumi.set(__self__, "hostname_count", hostname_count)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if notify_emails is not None:
            pulumi.set(__self__, "notify_emails", notify_emails)
        if timeout_for_activation is not None:
            pulumi.set(__self__, "timeout_for_activation", timeout_for_activation)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> pulumi.Input[Mapping[str, pulumi.Input['PropertyHostnameBucketHostnamesArgs']]]:
        """
        The hostnames mapping. The key represents 'cname_from' and the value contains hostnames details, consisting of
        certificate provisioning type and edge hostname.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: pulumi.Input[Mapping[str, pulumi.Input['PropertyHostnameBucketHostnamesArgs']]]):
        pulumi.set(self, "hostnames", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        The network to activate on, either `STAGING` or `PRODUCTION`.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier for the property.
        """
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "property_id", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the contract. Provide it if resolving the property without 'contract_id' and 'group_id' is not
        possible
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the group. Provide it if resolving the property without 'contract_id' and 'group_id' is not
        possible
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="hostnameCount")
    def hostname_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The computed number of hostnames after applying desired modifications. Used only to informduring the plan phase about
        the number of hostnames that will be active after making the changes.
        """
        return pulumi.get(self, "hostname_count")

    @hostname_count.setter
    def hostname_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hostname_count", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assigns a log message to the request.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter(name="notifyEmails")
    def notify_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Email addresses to notify when the activation status changes.
        """
        return pulumi.get(self, "notify_emails")

    @notify_emails.setter
    def notify_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notify_emails", value)

    @_builtins.property
    @pulumi.getter(name="timeoutForActivation")
    def timeout_for_activation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout value in minutes after which a single hostname activation will be canceled. Defaults to 50 minutes.
        """
        return pulumi.get(self, "timeout_for_activation")

    @timeout_for_activation.setter
    def timeout_for_activation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_for_activation", value)


@pulumi.input_type
class _PropertyHostnameBucketState:
    def __init__(__self__, *,
                 activation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_count: Optional[pulumi.Input[_builtins.int]] = None,
                 hostnames: Optional[pulumi.Input[Mapping[str, pulumi.Input['PropertyHostnameBucketHostnamesArgs']]]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pending_default_certs: Optional[pulumi.Input[_builtins.int]] = None,
                 property_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_for_activation: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering PropertyHostnameBucket resources.
        :param pulumi.Input[_builtins.str] activation_id: The ID of the latest hostname bucket activation.
        :param pulumi.Input[_builtins.str] contract_id: The unique identifier for the contract. Provide it if resolving the property without 'contract_id' and 'group_id' is not
               possible
        :param pulumi.Input[_builtins.str] group_id: The unique identifier for the group. Provide it if resolving the property without 'contract_id' and 'group_id' is not
               possible
        :param pulumi.Input[_builtins.int] hostname_count: The computed number of hostnames after applying desired modifications. Used only to informduring the plan phase about
               the number of hostnames that will be active after making the changes.
        :param pulumi.Input[Mapping[str, pulumi.Input['PropertyHostnameBucketHostnamesArgs']]] hostnames: The hostnames mapping. The key represents 'cname_from' and the value contains hostnames details, consisting of
               certificate provisioning type and edge hostname.
        :param pulumi.Input[_builtins.str] network: The network to activate on, either `STAGING` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_emails: Email addresses to notify when the activation status changes.
        :param pulumi.Input[_builtins.int] pending_default_certs: The number of hostnames with a `DEFAULT` certificate type that are still in the `PENDING` state.
        :param pulumi.Input[_builtins.str] property_id: The unique identifier for the property.
        :param pulumi.Input[_builtins.int] timeout_for_activation: The timeout value in minutes after which a single hostname activation will be canceled. Defaults to 50 minutes.
        """
        if activation_id is not None:
            pulumi.set(__self__, "activation_id", activation_id)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if hostname_count is not None:
            pulumi.set(__self__, "hostname_count", hostname_count)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if note is not None:
            pulumi.set(__self__, "note", note)
        if notify_emails is not None:
            pulumi.set(__self__, "notify_emails", notify_emails)
        if pending_default_certs is not None:
            pulumi.set(__self__, "pending_default_certs", pending_default_certs)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)
        if timeout_for_activation is not None:
            pulumi.set(__self__, "timeout_for_activation", timeout_for_activation)

    @_builtins.property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the latest hostname bucket activation.
        """
        return pulumi.get(self, "activation_id")

    @activation_id.setter
    def activation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "activation_id", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the contract. Provide it if resolving the property without 'contract_id' and 'group_id' is not
        possible
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the group. Provide it if resolving the property without 'contract_id' and 'group_id' is not
        possible
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="hostnameCount")
    def hostname_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The computed number of hostnames after applying desired modifications. Used only to informduring the plan phase about
        the number of hostnames that will be active after making the changes.
        """
        return pulumi.get(self, "hostname_count")

    @hostname_count.setter
    def hostname_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hostname_count", value)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['PropertyHostnameBucketHostnamesArgs']]]]:
        """
        The hostnames mapping. The key represents 'cname_from' and the value contains hostnames details, consisting of
        certificate provisioning type and edge hostname.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['PropertyHostnameBucketHostnamesArgs']]]]):
        pulumi.set(self, "hostnames", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network to activate on, either `STAGING` or `PRODUCTION`.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def note(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assigns a log message to the request.
        """
        return pulumi.get(self, "note")

    @note.setter
    def note(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "note", value)

    @_builtins.property
    @pulumi.getter(name="notifyEmails")
    def notify_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Email addresses to notify when the activation status changes.
        """
        return pulumi.get(self, "notify_emails")

    @notify_emails.setter
    def notify_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "notify_emails", value)

    @_builtins.property
    @pulumi.getter(name="pendingDefaultCerts")
    def pending_default_certs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of hostnames with a `DEFAULT` certificate type that are still in the `PENDING` state.
        """
        return pulumi.get(self, "pending_default_certs")

    @pending_default_certs.setter
    def pending_default_certs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pending_default_certs", value)

    @_builtins.property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the property.
        """
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "property_id", value)

    @_builtins.property
    @pulumi.getter(name="timeoutForActivation")
    def timeout_for_activation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout value in minutes after which a single hostname activation will be canceled. Defaults to 50 minutes.
        """
        return pulumi.get(self, "timeout_for_activation")

    @timeout_for_activation.setter
    def timeout_for_activation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_for_activation", value)


@pulumi.type_token("akamai:index/propertyHostnameBucket:PropertyHostnameBucket")
class PropertyHostnameBucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_count: Optional[pulumi.Input[_builtins.int]] = None,
                 hostnames: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['PropertyHostnameBucketHostnamesArgs', 'PropertyHostnameBucketHostnamesArgsDict']]]]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 property_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_for_activation: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a PropertyHostnameBucket resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contract_id: The unique identifier for the contract. Provide it if resolving the property without 'contract_id' and 'group_id' is not
               possible
        :param pulumi.Input[_builtins.str] group_id: The unique identifier for the group. Provide it if resolving the property without 'contract_id' and 'group_id' is not
               possible
        :param pulumi.Input[_builtins.int] hostname_count: The computed number of hostnames after applying desired modifications. Used only to informduring the plan phase about
               the number of hostnames that will be active after making the changes.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['PropertyHostnameBucketHostnamesArgs', 'PropertyHostnameBucketHostnamesArgsDict']]]] hostnames: The hostnames mapping. The key represents 'cname_from' and the value contains hostnames details, consisting of
               certificate provisioning type and edge hostname.
        :param pulumi.Input[_builtins.str] network: The network to activate on, either `STAGING` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_emails: Email addresses to notify when the activation status changes.
        :param pulumi.Input[_builtins.str] property_id: The unique identifier for the property.
        :param pulumi.Input[_builtins.int] timeout_for_activation: The timeout value in minutes after which a single hostname activation will be canceled. Defaults to 50 minutes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PropertyHostnameBucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PropertyHostnameBucket resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PropertyHostnameBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PropertyHostnameBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_count: Optional[pulumi.Input[_builtins.int]] = None,
                 hostnames: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['PropertyHostnameBucketHostnamesArgs', 'PropertyHostnameBucketHostnamesArgsDict']]]]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 note: Optional[pulumi.Input[_builtins.str]] = None,
                 notify_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 property_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_for_activation: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PropertyHostnameBucketArgs.__new__(PropertyHostnameBucketArgs)

            __props__.__dict__["contract_id"] = contract_id
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["hostname_count"] = hostname_count
            if hostnames is None and not opts.urn:
                raise TypeError("Missing required property 'hostnames'")
            __props__.__dict__["hostnames"] = hostnames
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["note"] = note
            __props__.__dict__["notify_emails"] = notify_emails
            if property_id is None and not opts.urn:
                raise TypeError("Missing required property 'property_id'")
            __props__.__dict__["property_id"] = property_id
            __props__.__dict__["timeout_for_activation"] = timeout_for_activation
            __props__.__dict__["activation_id"] = None
            __props__.__dict__["pending_default_certs"] = None
        super(PropertyHostnameBucket, __self__).__init__(
            'akamai:index/propertyHostnameBucket:PropertyHostnameBucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activation_id: Optional[pulumi.Input[_builtins.str]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            hostname_count: Optional[pulumi.Input[_builtins.int]] = None,
            hostnames: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['PropertyHostnameBucketHostnamesArgs', 'PropertyHostnameBucketHostnamesArgsDict']]]]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            note: Optional[pulumi.Input[_builtins.str]] = None,
            notify_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            pending_default_certs: Optional[pulumi.Input[_builtins.int]] = None,
            property_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeout_for_activation: Optional[pulumi.Input[_builtins.int]] = None) -> 'PropertyHostnameBucket':
        """
        Get an existing PropertyHostnameBucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] activation_id: The ID of the latest hostname bucket activation.
        :param pulumi.Input[_builtins.str] contract_id: The unique identifier for the contract. Provide it if resolving the property without 'contract_id' and 'group_id' is not
               possible
        :param pulumi.Input[_builtins.str] group_id: The unique identifier for the group. Provide it if resolving the property without 'contract_id' and 'group_id' is not
               possible
        :param pulumi.Input[_builtins.int] hostname_count: The computed number of hostnames after applying desired modifications. Used only to informduring the plan phase about
               the number of hostnames that will be active after making the changes.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['PropertyHostnameBucketHostnamesArgs', 'PropertyHostnameBucketHostnamesArgsDict']]]] hostnames: The hostnames mapping. The key represents 'cname_from' and the value contains hostnames details, consisting of
               certificate provisioning type and edge hostname.
        :param pulumi.Input[_builtins.str] network: The network to activate on, either `STAGING` or `PRODUCTION`.
        :param pulumi.Input[_builtins.str] note: Assigns a log message to the request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] notify_emails: Email addresses to notify when the activation status changes.
        :param pulumi.Input[_builtins.int] pending_default_certs: The number of hostnames with a `DEFAULT` certificate type that are still in the `PENDING` state.
        :param pulumi.Input[_builtins.str] property_id: The unique identifier for the property.
        :param pulumi.Input[_builtins.int] timeout_for_activation: The timeout value in minutes after which a single hostname activation will be canceled. Defaults to 50 minutes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PropertyHostnameBucketState.__new__(_PropertyHostnameBucketState)

        __props__.__dict__["activation_id"] = activation_id
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["hostname_count"] = hostname_count
        __props__.__dict__["hostnames"] = hostnames
        __props__.__dict__["network"] = network
        __props__.__dict__["note"] = note
        __props__.__dict__["notify_emails"] = notify_emails
        __props__.__dict__["pending_default_certs"] = pending_default_certs
        __props__.__dict__["property_id"] = property_id
        __props__.__dict__["timeout_for_activation"] = timeout_for_activation
        return PropertyHostnameBucket(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the latest hostname bucket activation.
        """
        return pulumi.get(self, "activation_id")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the contract. Provide it if resolving the property without 'contract_id' and 'group_id' is not
        possible
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the group. Provide it if resolving the property without 'contract_id' and 'group_id' is not
        possible
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="hostnameCount")
    def hostname_count(self) -> pulumi.Output[_builtins.int]:
        """
        The computed number of hostnames after applying desired modifications. Used only to informduring the plan phase about
        the number of hostnames that will be active after making the changes.
        """
        return pulumi.get(self, "hostname_count")

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> pulumi.Output[Mapping[str, 'outputs.PropertyHostnameBucketHostnames']]:
        """
        The hostnames mapping. The key represents 'cname_from' and the value contains hostnames details, consisting of
        certificate provisioning type and edge hostname.
        """
        return pulumi.get(self, "hostnames")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        The network to activate on, either `STAGING` or `PRODUCTION`.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def note(self) -> pulumi.Output[_builtins.str]:
        """
        Assigns a log message to the request.
        """
        return pulumi.get(self, "note")

    @_builtins.property
    @pulumi.getter(name="notifyEmails")
    def notify_emails(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Email addresses to notify when the activation status changes.
        """
        return pulumi.get(self, "notify_emails")

    @_builtins.property
    @pulumi.getter(name="pendingDefaultCerts")
    def pending_default_certs(self) -> pulumi.Output[_builtins.int]:
        """
        The number of hostnames with a `DEFAULT` certificate type that are still in the `PENDING` state.
        """
        return pulumi.get(self, "pending_default_certs")

    @_builtins.property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the property.
        """
        return pulumi.get(self, "property_id")

    @_builtins.property
    @pulumi.getter(name="timeoutForActivation")
    def timeout_for_activation(self) -> pulumi.Output[_builtins.int]:
        """
        The timeout value in minutes after which a single hostname activation will be canceled. Defaults to 50 minutes.
        """
        return pulumi.get(self, "timeout_for_activation")

