# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PropertyIncludeArgs', 'PropertyInclude']

@pulumi.input_type
class PropertyIncludeArgs:
    def __init__(__self__, *,
                 contract_id: pulumi.Input[_builtins.str],
                 group_id: pulumi.Input[_builtins.str],
                 rule_format: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PropertyInclude resource.
        :param pulumi.Input[_builtins.str] contract_id: Identifies the contract to which the include is assigned
        :param pulumi.Input[_builtins.str] group_id: Identifies the group to which the include is assigned
        :param pulumi.Input[_builtins.str] rule_format: Indicates the versioned set of features and criteria
        :param pulumi.Input[_builtins.str] type: Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        :param pulumi.Input[_builtins.str] name: A descriptive name for the include
        :param pulumi.Input[_builtins.str] product_id: The product assigned to the include
        :param pulumi.Input[_builtins.str] rules: Property Rules as JSON
        """
        pulumi.set(__self__, "contract_id", contract_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "rule_format", rule_format)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the contract to which the include is assigned
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifies the group to which the include is assigned
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates the versioned set of features and criteria
        """
        return pulumi.get(self, "rule_format")

    @rule_format.setter
    def rule_format(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_format", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A descriptive name for the include
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The product assigned to the include
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _PropertyIncludeState:
    def __init__(__self__, *,
                 asset_id: Optional[pulumi.Input[_builtins.str]] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 production_version: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_errors: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_format: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_warnings: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None,
                 staging_version: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PropertyInclude resources.
        :param pulumi.Input[_builtins.str] asset_id: ID of the include in the Identity and Access Management API.
        :param pulumi.Input[_builtins.str] contract_id: Identifies the contract to which the include is assigned
        :param pulumi.Input[_builtins.str] group_id: Identifies the group to which the include is assigned
        :param pulumi.Input[_builtins.int] latest_version: Specifies the most recent version of the include
        :param pulumi.Input[_builtins.str] name: A descriptive name for the include
        :param pulumi.Input[_builtins.str] product_id: The product assigned to the include
        :param pulumi.Input[_builtins.str] production_version: The most recent version to be activated to the production network
        :param pulumi.Input[_builtins.str] rule_errors: Rule validation errors
        :param pulumi.Input[_builtins.str] rule_format: Indicates the versioned set of features and criteria
        :param pulumi.Input[_builtins.str] rule_warnings: Rule validation warnings
        :param pulumi.Input[_builtins.str] rules: Property Rules as JSON
        :param pulumi.Input[_builtins.str] staging_version: The most recent version to be activated to the staging network
        :param pulumi.Input[_builtins.str] type: Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if contract_id is not None:
            pulumi.set(__self__, "contract_id", contract_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if production_version is not None:
            pulumi.set(__self__, "production_version", production_version)
        if rule_errors is not None:
            pulumi.set(__self__, "rule_errors", rule_errors)
        if rule_format is not None:
            pulumi.set(__self__, "rule_format", rule_format)
        if rule_warnings is not None:
            pulumi.set(__self__, "rule_warnings", rule_warnings)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if staging_version is not None:
            pulumi.set(__self__, "staging_version", staging_version)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the include in the Identity and Access Management API.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "asset_id", value)

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the contract to which the include is assigned
        """
        return pulumi.get(self, "contract_id")

    @contract_id.setter
    def contract_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "contract_id", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifies the group to which the include is assigned
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the most recent version of the include
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "latest_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A descriptive name for the include
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The product assigned to the include
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="productionVersion")
    def production_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The most recent version to be activated to the production network
        """
        return pulumi.get(self, "production_version")

    @production_version.setter
    def production_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "production_version", value)

    @_builtins.property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule validation errors
        """
        return pulumi.get(self, "rule_errors")

    @rule_errors.setter
    def rule_errors(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_errors", value)

    @_builtins.property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the versioned set of features and criteria
        """
        return pulumi.get(self, "rule_format")

    @rule_format.setter
    def rule_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_format", value)

    @_builtins.property
    @pulumi.getter(name="ruleWarnings")
    def rule_warnings(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule validation warnings
        """
        return pulumi.get(self, "rule_warnings")

    @rule_warnings.setter
    def rule_warnings(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_warnings", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter(name="stagingVersion")
    def staging_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The most recent version to be activated to the staging network
        """
        return pulumi.get(self, "staging_version")

    @staging_version.setter
    def staging_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "staging_version", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("akamai:index/propertyInclude:PropertyInclude")
class PropertyInclude(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_format: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a PropertyInclude resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] contract_id: Identifies the contract to which the include is assigned
        :param pulumi.Input[_builtins.str] group_id: Identifies the group to which the include is assigned
        :param pulumi.Input[_builtins.str] name: A descriptive name for the include
        :param pulumi.Input[_builtins.str] product_id: The product assigned to the include
        :param pulumi.Input[_builtins.str] rule_format: Indicates the versioned set of features and criteria
        :param pulumi.Input[_builtins.str] rules: Property Rules as JSON
        :param pulumi.Input[_builtins.str] type: Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PropertyIncludeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PropertyInclude resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PropertyIncludeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PropertyIncludeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contract_id: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_format: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PropertyIncludeArgs.__new__(PropertyIncludeArgs)

            if contract_id is None and not opts.urn:
                raise TypeError("Missing required property 'contract_id'")
            __props__.__dict__["contract_id"] = contract_id
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["name"] = name
            __props__.__dict__["product_id"] = product_id
            if rule_format is None and not opts.urn:
                raise TypeError("Missing required property 'rule_format'")
            __props__.__dict__["rule_format"] = rule_format
            __props__.__dict__["rules"] = rules
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["asset_id"] = None
            __props__.__dict__["latest_version"] = None
            __props__.__dict__["production_version"] = None
            __props__.__dict__["rule_errors"] = None
            __props__.__dict__["rule_warnings"] = None
            __props__.__dict__["staging_version"] = None
        super(PropertyInclude, __self__).__init__(
            'akamai:index/propertyInclude:PropertyInclude',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            asset_id: Optional[pulumi.Input[_builtins.str]] = None,
            contract_id: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            latest_version: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            product_id: Optional[pulumi.Input[_builtins.str]] = None,
            production_version: Optional[pulumi.Input[_builtins.str]] = None,
            rule_errors: Optional[pulumi.Input[_builtins.str]] = None,
            rule_format: Optional[pulumi.Input[_builtins.str]] = None,
            rule_warnings: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[_builtins.str]] = None,
            staging_version: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'PropertyInclude':
        """
        Get an existing PropertyInclude resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] asset_id: ID of the include in the Identity and Access Management API.
        :param pulumi.Input[_builtins.str] contract_id: Identifies the contract to which the include is assigned
        :param pulumi.Input[_builtins.str] group_id: Identifies the group to which the include is assigned
        :param pulumi.Input[_builtins.int] latest_version: Specifies the most recent version of the include
        :param pulumi.Input[_builtins.str] name: A descriptive name for the include
        :param pulumi.Input[_builtins.str] product_id: The product assigned to the include
        :param pulumi.Input[_builtins.str] production_version: The most recent version to be activated to the production network
        :param pulumi.Input[_builtins.str] rule_errors: Rule validation errors
        :param pulumi.Input[_builtins.str] rule_format: Indicates the versioned set of features and criteria
        :param pulumi.Input[_builtins.str] rule_warnings: Rule validation warnings
        :param pulumi.Input[_builtins.str] rules: Property Rules as JSON
        :param pulumi.Input[_builtins.str] staging_version: The most recent version to be activated to the staging network
        :param pulumi.Input[_builtins.str] type: Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PropertyIncludeState.__new__(_PropertyIncludeState)

        __props__.__dict__["asset_id"] = asset_id
        __props__.__dict__["contract_id"] = contract_id
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["latest_version"] = latest_version
        __props__.__dict__["name"] = name
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["production_version"] = production_version
        __props__.__dict__["rule_errors"] = rule_errors
        __props__.__dict__["rule_format"] = rule_format
        __props__.__dict__["rule_warnings"] = rule_warnings
        __props__.__dict__["rules"] = rules
        __props__.__dict__["staging_version"] = staging_version
        __props__.__dict__["type"] = type
        return PropertyInclude(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the include in the Identity and Access Management API.
        """
        return pulumi.get(self, "asset_id")

    @_builtins.property
    @pulumi.getter(name="contractId")
    def contract_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the contract to which the include is assigned
        """
        return pulumi.get(self, "contract_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifies the group to which the include is assigned
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the most recent version of the include
        """
        return pulumi.get(self, "latest_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A descriptive name for the include
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The product assigned to the include
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="productionVersion")
    def production_version(self) -> pulumi.Output[_builtins.str]:
        """
        The most recent version to be activated to the production network
        """
        return pulumi.get(self, "production_version")

    @_builtins.property
    @pulumi.getter(name="ruleErrors")
    def rule_errors(self) -> pulumi.Output[_builtins.str]:
        """
        Rule validation errors
        """
        return pulumi.get(self, "rule_errors")

    @_builtins.property
    @pulumi.getter(name="ruleFormat")
    def rule_format(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the versioned set of features and criteria
        """
        return pulumi.get(self, "rule_format")

    @_builtins.property
    @pulumi.getter(name="ruleWarnings")
    def rule_warnings(self) -> pulumi.Output[_builtins.str]:
        """
        Rule validation warnings
        """
        return pulumi.get(self, "rule_warnings")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[_builtins.str]:
        """
        Property Rules as JSON
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="stagingVersion")
    def staging_version(self) -> pulumi.Output[_builtins.str]:
        """
        The most recent version to be activated to the staging network
        """
        return pulumi.get(self, "staging_version")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of the include, either 'MICROSERVICES' or 'COMMON_SETTINGS'
        """
        return pulumi.get(self, "type")

