from rich.style import Style
from textual._text_area_theme import TextAreaTheme

SOURCERER_THEME_NAME = "sourcerer"
# Terraform theme for the text area.
sourcerer_text_area_theme = TextAreaTheme(
    name=SOURCERER_THEME_NAME,
    cursor_style=Style(color="#1e1e1e", bgcolor="#f0f0f0"),
    cursor_line_style=Style(bgcolor="#2b2b2b"),
    bracket_matching_style=Style(bgcolor="#3a3a3a", bold=True),
    cursor_line_gutter_style=Style(color="#CCCCCC", bgcolor="#2b2b2b"),
    selection_style=Style(bgcolor="#FFA656"),
    syntax_styles={
        "string": Style(color="#79C0FF"),
        "string.documentation": Style(color="#79C0FF"),
        "comment": Style(color="#6A9955"),
        "heading.marker": Style(color="#6E7681"),
        "keyword": Style(color="#C586C0"),
        "operator": Style(color="#CCCCCC"),
        "conditional": Style(color="#569cd6"),
        "keyword.function": Style(color="#F97970"),
        "keyword.return": Style(color="#569cd6"),
        "keyword.operator": Style(color="#569cd6"),
        "repeat": Style(color="#569cd6"),
        "exception": Style(color="#569cd6"),
        "include": Style(color="#569cd6"),
        "number": Style(color="#b5cea8"),
        "float": Style(color="#b5cea8"),
        "class": Style(color="#4EC9B0"),
        "type": Style(color="#EFCB43"),
        "type.class": Style(color="#FFA656"),
        "type.builtin": Style(color="#CDD9E5"),
        "function": Style(color="#CCB0EA"),
        "function.call": Style(color="#CCB0EA"),
        "method": Style(color="#CCB0EA"),
        "method.call": Style(color="#CCB0EA"),
        "constructor": Style(color="#DCBDFB"),
        "boolean": Style(color="#7DAF9C"),
        "constant.builtin": Style(color="#7DAF9C"),
        "json.null": Style(color="#FDA556"),
        "tag": Style(color="#EFCB43"),
        "yaml.field": Style(color="#569cd6", bold=True),
        "json.label": Style(color="#8EDB8C", bold=True),
        "toml.type": Style(color="#569cd6"),
        "toml.datetime": Style(color="#C586C0", italic=True),
        "css.property": Style(color="#569cd6"),
        "heading": Style(color="#569cd6", bold=True),
        "bold": Style(bold=True),
        "italic": Style(italic=True),
        "strikethrough": Style(strike=True),
        "link.uri": Style(color="#40A6FF", underline=True),
        "link.label": Style(color="#569cd6"),
        "list.marker": Style(color="#6E7681"),
        "inline_code": Style(color="#ce9178"),
        "info_string": Style(color="#ce9178", bold=True, italic=True),
        "punctuation.bracket": Style(color="#CCCCCC"),
        "punctuation.delimiter": Style(color="#CCCCCC"),
        "punctuation.special": Style(color="#CCCCCC"),
    },
)
