# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AlertCheckJobSpec(BaseModel):
    """
    AlertCheckJobSpec
    """ # noqa: E501
    job_type: Optional[StrictStr] = 'alert_check'
    scope_model_id: StrictStr = Field(description="The id of the model to check alerts.")
    check_range_start_timestamp: datetime = Field(description="The start timestamp to use for checking the alerts on the data.")
    check_range_end_timestamp: datetime = Field(description="The end timestamp to use for checking the alerts on the data.")
    metric_version: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["job_type", "scope_model_id", "check_range_start_timestamp", "check_range_end_timestamp", "metric_version"]

    @field_validator('job_type')
    def job_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['alert_check']):
            raise ValueError("must be one of enum values ('alert_check')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AlertCheckJobSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if metric_version (nullable) is None
        # and model_fields_set contains the field
        if self.metric_version is None and "metric_version" in self.model_fields_set:
            _dict['metric_version'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AlertCheckJobSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "job_type": obj.get("job_type") if obj.get("job_type") is not None else 'alert_check',
            "scope_model_id": obj.get("scope_model_id"),
            "check_range_start_timestamp": obj.get("check_range_start_timestamp"),
            "check_range_end_timestamp": obj.get("check_range_end_timestamp"),
            "metric_version": obj.get("metric_version")
        })
        return _obj


