# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from scope_client.api_bindings.models.dataset_reference import DatasetReference
from scope_client.api_bindings.models.model_metric_spec import ModelMetricSpec
from scope_client.api_bindings.models.model_metrics_schedule import ModelMetricsSchedule
from scope_client.api_bindings.models.model_problem_type import ModelProblemType
from scope_client.api_bindings.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class Model(BaseModel):
    """
    Model
    """ # noqa: E501
    created_at: datetime = Field(description="Time of record creation.")
    updated_at: datetime = Field(description="Time of last record update.")
    id: StrictStr = Field(description="ID of the model.")
    project_id: StrictStr = Field(description="ID of the parent project.")
    name: StrictStr = Field(description="Name of the model.")
    description: Optional[StrictStr]
    last_updated_by_user: Optional[User] = None
    metric_config: ModelMetricSpec = Field(description="Metric configuration of the model.")
    schedule: Optional[ModelMetricsSchedule] = None
    model_problem_types: List[ModelProblemType] = Field(description="Unique model problem types of associated datasets.")
    datasets: List[DatasetReference] = Field(description="Datasets for the model.")
    __properties: ClassVar[List[str]] = ["created_at", "updated_at", "id", "project_id", "name", "description", "last_updated_by_user", "metric_config", "schedule", "model_problem_types", "datasets"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Model from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of last_updated_by_user
        if self.last_updated_by_user:
            _dict['last_updated_by_user'] = self.last_updated_by_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metric_config
        if self.metric_config:
            _dict['metric_config'] = self.metric_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of schedule
        if self.schedule:
            _dict['schedule'] = self.schedule.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in datasets (list)
        _items = []
        if self.datasets:
            for _item_datasets in self.datasets:
                if _item_datasets:
                    _items.append(_item_datasets.to_dict())
            _dict['datasets'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if last_updated_by_user (nullable) is None
        # and model_fields_set contains the field
        if self.last_updated_by_user is None and "last_updated_by_user" in self.model_fields_set:
            _dict['last_updated_by_user'] = None

        # set to None if schedule (nullable) is None
        # and model_fields_set contains the field
        if self.schedule is None and "schedule" in self.model_fields_set:
            _dict['schedule'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Model from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "id": obj.get("id"),
            "project_id": obj.get("project_id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "last_updated_by_user": User.from_dict(obj["last_updated_by_user"]) if obj.get("last_updated_by_user") is not None else None,
            "metric_config": ModelMetricSpec.from_dict(obj["metric_config"]) if obj.get("metric_config") is not None else None,
            "schedule": ModelMetricsSchedule.from_dict(obj["schedule"]) if obj.get("schedule") is not None else None,
            "model_problem_types": obj.get("model_problem_types"),
            "datasets": [DatasetReference.from_dict(_item) for _item in obj["datasets"]] if obj.get("datasets") is not None else None
        })
        return _obj


