# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from scope_client.api_bindings.models.alert_bound import AlertBound
from typing import Optional, Set
from typing_extensions import Self

class PostAlert(BaseModel):
    """
    PostAlert
    """ # noqa: E501
    description: Optional[StrictStr]
    timestamp: datetime = Field(description="The timestamp of the alert.")
    value: Union[StrictFloat, StrictInt] = Field(description="The value of the metric that triggered the alert.")
    threshold: Union[StrictFloat, StrictInt] = Field(description="The threshold that triggered the alert.")
    bound: AlertBound = Field(description="The bound of the alert.")
    metric_version: Optional[StrictInt]
    dimensions: Optional[Dict[str, Any]]
    alert_rule_id: StrictStr = Field(description="The alert rule id of the alert.")
    job_id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["description", "timestamp", "value", "threshold", "bound", "metric_version", "dimensions", "alert_rule_id", "job_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostAlert from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if metric_version (nullable) is None
        # and model_fields_set contains the field
        if self.metric_version is None and "metric_version" in self.model_fields_set:
            _dict['metric_version'] = None

        # set to None if dimensions (nullable) is None
        # and model_fields_set contains the field
        if self.dimensions is None and "dimensions" in self.model_fields_set:
            _dict['dimensions'] = None

        # set to None if job_id (nullable) is None
        # and model_fields_set contains the field
        if self.job_id is None and "job_id" in self.model_fields_set:
            _dict['job_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostAlert from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "timestamp": obj.get("timestamp"),
            "value": obj.get("value"),
            "threshold": obj.get("threshold"),
            "bound": obj.get("bound"),
            "metric_version": obj.get("metric_version"),
            "dimensions": obj.get("dimensions"),
            "alert_rule_id": obj.get("alert_rule_id"),
            "job_id": obj.get("job_id")
        })
        return _obj


