from heaobject.registry import Resource
from heaobject.volume import DEFAULT_FILE_SYSTEM

from ..testcase.dockermongo import DockerMongoManager
from .microservicetestcase import get_test_case_cls_default as _get_test_case_cls_default
from .testenv import DockerContainerConfig, MicroserviceContainerConfig
from .dockermongo import RealRegistryContainerConfig
from functools import partial
from copy import deepcopy


_HEASERVER_REGISTRY_IMAGE = 'registry.gitlab.com/huntsman-cancer-institute/risr/hea/heaserver-registry:1.0.0b3'
_HEASERVER_VOLUMES_IMAGE = 'registry.gitlab.com/huntsman-cancer-institute/risr/hea/heaserver-volumes:1.0.0b3'
_HEASERVER_KEYCHAIN_IMAGE = 'registry.gitlab.com/huntsman-cancer-institute/risr/hea/heaserver-keychain:1.0.0b4'
_RABBITMQ_IMAGE = 'rabbitmq:3.10.7-management'

_volume_microservice = MicroserviceContainerConfig(image=_HEASERVER_VOLUMES_IMAGE, port=8080, check_path='/volumes',
                                                   resources=[Resource(resource_type_name='heaobject.volume.Volume',
                                                                      base_path='volumes',
                                                                      file_system_name=DEFAULT_FILE_SYSTEM),
                                                             Resource(resource_type_name='heaobject.volume.FileSystem',
                                                                      base_path='filesystems',
                                                                      file_system_name=DEFAULT_FILE_SYSTEM)],
                                                   db_manager_cls=DockerMongoManager)
_keychain_microservice = MicroserviceContainerConfig(image=_HEASERVER_KEYCHAIN_IMAGE, port=8080,
                                                     check_path='/credentials',
                                                     resources=[
                                                        Resource(resource_type_name='heaobject.keychain.Credentials',
                                                                 base_path='credentials',
                                                                 file_system_name=DEFAULT_FILE_SYSTEM)],
                                                     db_manager_cls=DockerMongoManager)
_rabbitmq = DockerContainerConfig(image=_RABBITMQ_IMAGE, ports=[5672, 15672])

get_test_case_cls_default = partial(_get_test_case_cls_default,
                                    registry_docker_image=RealRegistryContainerConfig(_HEASERVER_REGISTRY_IMAGE),
                                    other_docker_images=[_volume_microservice, _keychain_microservice])
get_test_case_cls_default.__doc__ = """
    A partial of the get_test_case_cls_default function in the microservicetestcase module with preset
    registry_docker_image and other_docker_image keyword arguments. It is provided for convenience to test an AWS
    S3-based HEA microservice. The test environment will launch containers for the HEA Registry Microservice,
    the HEA Volumes Microservice, and the HEA Keychain Microservice on port 8080 using
    DockerMongoManager. Test case classes generated by this function should only be used for integration tests. You can
    add to the docker containers to be started by appending to this object's .keywords['other_docker_images'] list. A
    convenience function is provided below, with_docker_images, for this purpose.
    """


def with_docker_images(get_test_case_cls_default_: partial,
                       *docker_container_configs: DockerContainerConfig) -> partial:
    """
    Add more docker container configs to this module's get_test_case_cls_default partial.
    """
    get_test_case_cls_default_ = deepcopy(get_test_case_cls_default_)
    get_test_case_cls_default_.keywords['other_docker_images'].extend(docker_container_configs)
    return get_test_case_cls_default_

