#!/usr/bin/env python
# -*- coding: utf-8 -*-

from .autocorr import autocorr
from .average_vdf import average_vdf
from .avg_4sc import avg_4sc
from .c_4_grad import c_4_grad
from .c_4_j import c_4_j
from .c_4_k import c_4_k
from .c_4_v import c_4_v
from .calc_ag import calc_ag
from .calc_agyro import calc_agyro
from .calc_dng import calc_dng
from .calc_dt import calc_dt
from .calc_fs import calc_fs
from .calc_sqrtq import calc_sqrtq
from .cart2sph import cart2sph
from .cart2sph_ts import cart2sph_ts
from .cdfepoch2datetime64 import cdfepoch2datetime64
from .compress_cwt import compress_cwt
from .convert_fac import convert_fac
from .corr_deriv import corr_deriv
from .cotrans import cotrans
from .cross import cross
from .date_str import date_str
from .datetime2iso8601 import datetime2iso8601
from .datetime642iso8601 import datetime642iso8601
from .datetime642ttns import datetime642ttns
from .datetime642unix import datetime642unix
from .dec_par_perp import dec_par_perp
from .dist_append import dist_append
from .dot import dot
from .dynamic_press import dynamic_press
from .e_vxb import e_vxb
from .eb_nrf import eb_nrf
from .ebsp import ebsp
from .edb import edb
from .end import end
from .estimate import estimate
from .extend_tint import extend_tint
from .filt import filt
from .find_closest import find_closest
from .get_omni_data import get_omni_data
from .gradient import gradient
from .gse2gsm import gse2gsm
from .histogram import histogram
from .histogram2d import histogram2d
from .increments import increments
from .int_sph_dist import int_sph_dist
from .integrate import integrate
from .iplasma_calc import iplasma_calc
from .iso2unix import iso2unix
from .iso86012datetime import iso86012datetime
from .iso86012datetime64 import iso86012datetime64
from .iso86012timevec import iso86012timevec
from .l_shell import l_shell
from .lowpass import lowpass
from .magnetosphere import magnetosphere
from .match_phibe_dir import match_phibe_dir
from .match_phibe_v import match_phibe_v
from .mean import mean
from .mean_bins import mean_bins
from .mean_field import mean_field
from .medfilt import medfilt
from .median_bins import median_bins
from .movmean import movmean
from .mva import mva
from .new_xyz import new_xyz
from .norm import norm
from .normalize import normalize
from .optimize_nbins_1d import optimize_nbins_1d
from .optimize_nbins_2d import optimize_nbins_2d
from .pid_4sc import pid_4sc
from .plasma_calc import plasma_calc
from .poynting_flux import poynting_flux
from .pres_anis import pres_anis
from .psd import psd
from .pvi import pvi
from .pvi_4sc import pvi_4sc

# @Louis Richard
from .read_cdf import read_cdf
from .remove_repeated_points import remove_repeated_points
from .resample import resample
from .shock_normal import shock_normal
from .shock_parameters import shock_parameters
from .solid_angle import solid_angle
from .sph2cart import sph2cart
from .start import start
from .struct_func import struct_func
from .t_eval import t_eval
from .time_clip import time_clip
from .timevec2iso8601 import timevec2iso8601
from .trace import trace
from .ts_append import ts_append
from .ts_scalar import ts_scalar
from .ts_skymap import ts_skymap
from .ts_tensor_xyz import ts_tensor_xyz
from .ts_time import ts_time
from .ts_vec_xyz import ts_vec_xyz
from .ttns2datetime64 import ttns2datetime64
from .unix2datetime64 import unix2datetime64
from .vht import vht
from .wave_fft import wave_fft
from .wavelet import wavelet
from .wavepolarize_means import wavepolarize_means
from .waverage import waverage

__author__ = "Louis Richard"
__email__ = "louisr@irfu.se"
__copyright__ = "Copyright 2020-2023"
__license__ = "MIT"
__version__ = "2.4.2"
__status__ = "Prototype"

__all__ = [
    "autocorr",
    "average_vdf",
    "avg_4sc",
    "c_4_grad",
    "c_4_j",
    "c_4_k",
    "c_4_v",
    "calc_ag",
    "calc_agyro",
    "calc_dng",
    "calc_dt",
    "calc_fs",
    "calc_sqrtq",
    "cart2sph",
    "cart2sph_ts",
    "cdfepoch2datetime64",
    "compress_cwt",
    "convert_fac",
    "corr_deriv",
    "cotrans",
    "cross",
    "date_str",
    "datetime2iso8601",
    "datetime642iso8601",
    "datetime642ttns",
    "datetime642unix",
    "dec_par_perp",
    "dist_append",
    "dot",
    "dynamic_press",
    "e_vxb",
    "eb_nrf",
    "ebsp",
    "edb",
    "end",
    "estimate",
    "extend_tint",
    "filt",
    "find_closest",
    "get_omni_data",
    "gradient",
    "gse2gsm",
    "histogram",
    "histogram2d",
    "increments",
    "int_sph_dist",
    "integrate",
    "iplasma_calc",
    "iso2unix",
    "iso86012datetime",
    "iso86012datetime64",
    "iso86012timevec",
    "l_shell",
    "lowpass",
    "magnetosphere",
    "match_phibe_dir",
    "match_phibe_v",
    "mean",
    "mean_bins",
    "mean_field",
    "medfilt",
    "median_bins",
    "movmean",
    "mva",
    "new_xyz",
    "norm",
    "normalize",
    "optimize_nbins_1d",
    "optimize_nbins_2d",
    "pid_4sc",
    "plasma_beta",
    "plasma_calc",
    "poynting_flux",
    "pres_anis",
    "psd",
    "pvi",
    "pvi_4sc",
    "read_cdf",
    "remove_repeated_points",
    "resample",
    "shock_normal",
    "shock_parameters",
    "solid_angle",
    "sph2cart",
    "st_diff",
    "start",
    "struct_func",
    "t_eval",
    "time_clip",
    "timevec2iso8601",
    "trace",
    "ts_append",
    "ts_scalar",
    "ts_skymap",
    "ts_tensor_xyz",
    "ts_time",
    "ts_vec_xyz",
    "ttns2datetime64",
    "unix2datetime64",
    "vht",
    "wave_fft",
    "wavelet",
    "wavepolarize_means",
    "waverage",
]
