# Examples

pydiverse.pipedag already has quite a rich set of features. So we like to provide some examples showing typical use cases.

* [Quickstart example](/quickstart)
* [Simple pipeline](/examples/simple_pipeline)
* [Working with real database](/database_testing)
* [Imperative materialization / Materializing Subqueries](/examples/imperative_materialization)
* [Interactive development](/examples/interactive_development)
* [Grouping Tasks/Stages and visualization](/examples/group_and_visualize)
* [Stage validation before schema swap](/examples/stage_validation)
* [Slightly more realistic pipeline](/examples/realistic_pipeline)
* [Introduction to vectorization principle with some example pipelines](https://github.com/Quantco/vectorization-tutorial/blob/main/README.md)
* [Multiple instances: full, mini, midi](/examples/multi_instance_pipeline)
* [Raw SQL example](/examples/raw_sql)
* [Best practices / moving from Raw SQL over handwritten SELECT statements to programmatic SQL](/examples/best_practices_sql)
* [Best practices / multiple instances: full_fresh, full_stable, mini_stable, midi_stable](/examples/best_practices_instances)
* [Best practices / inline views, CTEs, and subqueries](/examples/best_practices_inline)

```{toctree}
/quickstart
/examples/simple_pipeline
/database_testing
/examples/imperative_materialization
/examples/interactive_development
/examples/group_and_visualize
/examples/stage_validation
/examples/realistic_pipeline
/examples/multi_instance_pipeline
/examples/raw_sql
```
