from datetime import datetime
from typing import Any

from pydantic import BaseModel, Field


class Tool(BaseModel):
    name: str = Field(
        ...,
        description="The name of the function to call."
    )

    arguments: dict[str, Any] | None = Field(
        default=None,
        description="The arguments to call the function with, as generated by the model in JSON format"
    )

    tool_type: str | None = Field(
        default=None,
        description="The type of the tool"
    )


class Message(BaseModel):
    role: str = Field(
        ...,
        description="Role of the message sender, e.g., 'assistant', 'user', or 'system'"
    )

    model: str = Field(
        ...,
        description="The model used for the chat completion."
    )

    content: str | None = Field(
        default=None,
        description="Content of the message"
    )

    tool_calls: list[Tool] | None = Field(
        default=None,
        description="The name and arguments of a function that should be called, as generated by the model."
    )

    system_fingerprint: str | None = Field(
        default=None,
        description="This fingerprint represents the backend configuration that the model runs with"
    )

    completion_tokens: int = Field(
        default=0,
        description="Number of tokens in the generated completion."
    )

    prompt_tokens: int = Field(
        default=0,
        description="Number of tokens in the prompt."
    )

    total_tokens: int = Field(
        default=0,
        description="Total number of tokens used in the request (prompt + completion)."
    )

    reasoning_tokens: int = Field(
        default=0,
        description="Tokens generated by the model for reasoning."
    )

    created: datetime = Field(
        description="The timestamp when the message was created, in datetime format."
    )  # Updated created field as datetime
