---
name: 🧹 Cleanup
about: Report code cleanup, refactoring, or maintenance tasks
title: '[CLEANUP]: '
labels: 'cleanup'
assignees: ''

---

**Area of cleanup**
Describe the area of the codebase that needs cleanup (e.g., specific modules, files, or directories).

**Type of cleanup**
- [ ] Code refactoring
- [ ] Remove deprecated code
- [ ] Update dependencies
- [ ] Improve documentation
- [ ] Code formatting/style consistency
- [ ] Remove unused code/variables
- [ ] Performance optimization
- [ ] Memory leak fixes
- [ ] Other (please specify)

**Current state**
Describe the current state of the code that needs cleanup. What makes it messy or problematic?

**Proposed improvements**
Describe what the cleaned-up code should look like. What improvements do you suggest?

**Benefits**
- [ ] Improved code readability
- [ ] Better performance
- [ ] Reduced technical debt
- [ ] Easier maintenance
- [ ] Better test coverage
- [ ] Other (please specify)

**Priority**
- [ ] Low - Nice to have
- [ ] Medium - Should be addressed soon
- [ ] High - Urgent cleanup needed

**Additional context**
Add any other context, screenshots, or examples about the cleanup task here.

**Related issues/PRs**
Link any related issues or pull requests that are connected to this cleanup task.
