# - Find Tcmalloc
# Find the native Tcmalloc includes and library
#
#  Tcmalloc_INCLUDE_DIR - where to find Tcmalloc.h, etc.
#  Tcmalloc_LIBRARIES   - List of libraries when using Tcmalloc.
#  Tcmalloc_FOUND       - True if Tcmalloc found.

find_path(Tcmalloc_INCLUDE_DIR google/tcmalloc.h NO_DEFAULT_PATH PATHS
        ${HT_DEPENDENCY_INCLUDE_DIR}
        /usr/include
        /opt/local/include
        /usr/local/include
        )

if (USE_TCMALLOC)
    set(Tcmalloc_NAMES tcmalloc)
else ()
    set(Tcmalloc_NAMES tcmalloc_minimal tcmalloc)
endif ()

find_library(Tcmalloc_LIBRARY NO_DEFAULT_PATH
        NAMES ${Tcmalloc_NAMES}
        PATHS ${HT_DEPENDENCY_LIB_DIR} /lib /usr/lib /usr/local/lib /opt/local/lib /usr/lib/x86_64-linux-gnu/ /lib/
        )

# if (Tcmalloc_INCLUDE_DIR AND Tcmalloc_LIBRARY)
if (Tcmalloc_LIBRARY)
    set(Tcmalloc_FOUND TRUE)
    set( Tcmalloc_LIBRARIES ${Tcmalloc_LIBRARY} )
else ()
    set(Tcmalloc_FOUND FALSE)
    set( Tcmalloc_LIBRARIES )
endif ()

if (Tcmalloc_FOUND)
#    message(STATUS "Found Tcmalloc: ${Tcmalloc_LIBRARY}")
else ()
    message(STATUS "Not Found Tcmalloc: ${Tcmalloc_LIBRARY}")
    if (Tcmalloc_FIND_REQUIRED)
        message(STATUS "Looked for Tcmalloc libraries named ${Tcmalloc_NAMES}.")
        message(FATAL_ERROR "Could NOT find Tcmalloc library")
    endif ()
endif ()

mark_as_advanced(
        Tcmalloc_LIBRARY
        Tcmalloc_INCLUDE_DIR
)