import pickle
from .uframe_instance import uframe_instance
from .uframe import uframe as ufr



def load_uframe(file):
    """
    Deserialize and load a uframe object from a file.

    This function restores a `uframe` object from a specified file, previously saved using the `uframe.save` method. It is useful for reloading data and models for further analysis, continuation of work, or model inference.

    Parameters
    ----------
    file : str
        The path to the file from which the `uframe` object will be loaded. The file must have been created by the `uframe.save` method, and should be a pickle (.pkl) file containing the serialized `uframe` object.

    Returns
    -------
    uframe
        The `uframe` object restored from the specified file. This object will include all the data instances and configurations that were present at the time the `uframe` was saved.

    Notes
    -----
    - The `load_uframe` function is designed to work with files generated by the `uframe.save` method, ensuring compatibility and ease of use.
    - As with any operation that involves deserializing from a file, it is crucial to ensure that the file being loaded is from a trusted source to avoid executing malicious code.

    Examples
    --------
    >>> loaded_uf = load_uframe('my_uframe_data.pkl')
    This example loads a `uframe` object from the file 'my_uframe_data.pkl', allowing it to be used immediately for analysis, visualization, or further processing.
    """
    with open(file, 'rb') as f:
        l = pickle.load(f)

    instances = [] 
    for i in range(len(l)):
        instances.append(uframe_instance(certain_data = l[i][0],
                                         continuous = l[i][1],
                                         categorical = l[i][2],
                                         indices = l[i][3]))

    uf = ufr(instances)

    return(uf)


