import { aws_ec2 as ec2, aws_secretsmanager as secretsmanager, CustomResource } from "aws-cdk-lib";
import { Construct } from "constructs";
export interface PgBouncerConfigProps {
    poolMode?: "transaction" | "session" | "statement";
    maxClientConn?: number;
    defaultPoolSize?: number;
    minPoolSize?: number;
    reservePoolSize?: number;
    reservePoolTimeout?: number;
    maxDbConnections?: number;
    maxUserConnections?: number;
}
export interface PgBouncerProps {
    /**
     * VPC to deploy PgBouncer into
     */
    vpc: ec2.IVpc;
    /**
     * The RDS instance to connect to
     */
    database: {
        connections: ec2.Connections;
        secret: secretsmanager.ISecret;
    };
    /**
     * Maximum connections setting for the database.
     * PgBouncer will use 10 fewer than this value.
     */
    dbMaxConnections: number;
    /**
     * Whether to deploy in public subnet
     * @default false
     */
    usePublicSubnet?: boolean;
    /**
     * PgBouncer configuration options
     */
    pgBouncerConfig?: PgBouncerConfigProps;
    /**
     * EC2 instance options
     */
    instanceProps?: Partial<ec2.InstanceProps>;
}
export declare class PgBouncer extends Construct {
    readonly instance: ec2.Instance;
    readonly pgbouncerSecret: secretsmanager.Secret;
    readonly securityGroup: ec2.SecurityGroup;
    readonly secretUpdateComplete: CustomResource;
    readonly healthCheck: CustomResource;
    private getDefaultPgbouncerConfig;
    constructor(scope: Construct, id: string, props: PgBouncerProps);
    private loadUserDataScript;
}
