import { aws_apigateway as apigateway, aws_dynamodb as dynamodb, aws_ec2 as ec2, aws_iam as iam, aws_secretsmanager as secretsmanager } from "aws-cdk-lib";
import { Construct } from "constructs";
import { CustomLambdaFunctionProps } from "../utils";
export declare class StacIngestor extends Construct {
    table: dynamodb.Table;
    handlerRole: iam.Role;
    constructor(scope: Construct, id: string, props: StacIngestorProps);
    private buildTable;
    private buildApiLambda;
    private buildIngestor;
    private buildApiEndpoint;
    private registerSsmParameter;
}
export interface StacIngestorProps {
    /**
     * ARN of AWS Role used to validate access to S3 data
     */
    readonly dataAccessRole: iam.IRole;
    /**
     * URL of STAC API
     */
    readonly stacUrl: string;
    /**
     * Stage of deployment (e.g. `dev`, `prod`)
     */
    readonly stage: string;
    /**
     * Secret containing pgSTAC DB connection information
     */
    readonly stacDbSecret: secretsmanager.ISecret;
    /**
     * VPC running pgSTAC DB
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Security Group used by pgSTAC DB
     */
    readonly stacDbSecurityGroup: ec2.ISecurityGroup;
    /**
     * Subnet into which the lambda should be deployed if using a VPC
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * Environment variables to be sent to Lambda.
     */
    readonly apiEnv?: Record<string, string>;
    /**
     * API Endpoint Configuration, useful for creating private APIs.
     */
    readonly apiEndpointConfiguration?: apigateway.EndpointConfiguration;
    /**
     * API Policy Document, useful for creating private APIs.
     */
    readonly apiPolicy?: iam.PolicyDocument;
    /**
     * Custom Domain Name Options for Ingestor API
     */
    readonly ingestorDomainNameOptions?: apigateway.DomainNameOptions;
    /**
     * Can be used to override the default lambda function properties.
     *
     * @default - default settings are defined in the construct.
     */
    readonly apiLambdaFunctionOptions?: CustomLambdaFunctionProps;
    /**
     * Can be used to override the default lambda function properties.
     *
     * @default - default settings are defined in the construct.
     */
    readonly ingestorLambdaFunctionOptions?: CustomLambdaFunctionProps;
    /**
     * pgstac version - must match the version installed on the pgstac database
     *
     * @default - default settings are defined in the construct
     */
    readonly pgstacVersion?: string;
}
