import { aws_apigateway as apigateway, aws_ec2 as ec2, aws_iam as iam, aws_lambda as lambda } from "aws-cdk-lib";
import { Construct } from "constructs";
export interface PrivateLambdaApiGatewayProps {
    /**
     * Lambda function to integrate with the API Gateway.
     */
    readonly lambdaFunction: lambda.IFunction;
    /**
     * Lambda integration options for the API Gateway.
     */
    readonly lambdaIntegrationOptions?: apigateway.LambdaIntegrationOptions;
    /**
     * VPC to create the API Gateway in.
     */
    readonly vpc: ec2.IVpc;
    /**
     * Whether to create a VPC endpoint for the API Gateway.
     *
     * @default - true
     */
    readonly createVpcEndpoint?: boolean;
    /**
     * The subnets in which to create a VPC endpoint network interface. At most one per availability zone.
  
     */
    readonly vpcEndpointSubnetSelection?: ec2.SubnetSelection;
    /**
     * Name for the API Gateway.
     *
     * @default - `${scope.node.id}-private-api`
     */
    readonly restApiName?: string;
    /**
     * Description for the API Gateway.
     *
     * @default - "Private REST API Gateway"
     */
    readonly description?: string;
    /**
     * Deploy options for the API Gateway.
     */
    readonly deployOptions?: apigateway.StageOptions;
    /**
     * Policy for the API Gateway.
     *
     * @default - Policy that allows any principal with the same VPC to invoke the API.
     */
    readonly policy?: iam.PolicyDocument;
}
export declare class PrivateLambdaApiGateway extends Construct {
    readonly api: apigateway.RestApi;
    readonly vpcEndpoint?: ec2.InterfaceVpcEndpoint;
    constructor(scope: Construct, id: string, props: PrivateLambdaApiGatewayProps);
}
