"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateLambdaApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class PrivateLambdaApiGateway extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { restApiName, description, lambdaFunction, vpc, vpcEndpointSubnetSelection, createVpcEndpoint = true, deployOptions, policy, lambdaIntegrationOptions, } = props;
        if (createVpcEndpoint) {
            // Create VPC Endpoint for API Gateway
            this.vpcEndpoint = new aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpoint(this, "vpc-endpoint", {
                vpc,
                service: aws_cdk_lib_1.aws_ec2.InterfaceVpcEndpointAwsService.APIGATEWAY,
                subnets: vpcEndpointSubnetSelection,
            });
        }
        const defaultIntegration = new aws_cdk_lib_1.aws_apigateway.LambdaIntegration(lambdaFunction, lambdaIntegrationOptions);
        // Create Private REST API Gateway
        this.api = new aws_cdk_lib_1.aws_apigateway.RestApi(this, "rest-api", {
            restApiName: restApiName ?? `${scope.node.id}-private-api`,
            description: description ?? "Private REST API Gateway",
            endpointTypes: [aws_cdk_lib_1.aws_apigateway.EndpointType.PRIVATE],
            policy: policy ??
                new aws_cdk_lib_1.aws_iam.PolicyDocument({
                    statements: [
                        new aws_cdk_lib_1.aws_iam.PolicyStatement({
                            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                            principals: [new aws_cdk_lib_1.aws_iam.AnyPrincipal()],
                            actions: ["execute-api:Invoke"],
                            resources: ["execute-api:/*"],
                            conditions: {
                                StringEquals: { "aws:SourceVpc": vpc.vpcId },
                            },
                        }),
                    ],
                }),
            deployOptions: deployOptions ?? {
                loggingLevel: aws_cdk_lib_1.aws_apigateway.MethodLoggingLevel.INFO,
                dataTraceEnabled: true,
            },
            defaultIntegration,
            defaultMethodOptions: {
                authorizationType: aws_cdk_lib_1.aws_apigateway.AuthorizationType.NONE,
            },
        });
        this.api.root.addMethod("ANY");
        this.api.root.addResource("{proxy+}").addMethod("ANY");
    }
}
exports.PrivateLambdaApiGateway = PrivateLambdaApiGateway;
_a = JSII_RTTI_SYMBOL_1;
PrivateLambdaApiGateway[_a] = { fqn: "eoapi-cdk.PrivateLambdaApiGateway", version: "10.2.1" };
//# sourceMappingURL=data:application/json;base64,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