import { aws_apigatewayv2 as apigatewayv2, aws_lambda as lambda } from "aws-cdk-lib";
import { Construct } from "constructs";
export interface LambdaApiGatewayProps {
    /**
     * Lambda function to integrate with the API Gateway.
     */
    readonly lambdaFunction: lambda.Function;
    /**
     * Custom Domain Name for the API. If defined, will create the
     * domain name and integrate it with the API.
     *
     * @default - undefined
     */
    readonly domainName?: apigatewayv2.IDomainName;
    /**
     * Name of the API Gateway.
     */
    readonly apiName?: string;
}
export declare class LambdaApiGateway extends Construct {
    readonly api: apigatewayv2.HttpApi;
    constructor(scope: Construct, id: string, props: LambdaApiGatewayProps);
}
