"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class LambdaApiGateway extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { apiName = `${aws_cdk_lib_1.Stack.of(this).stackName}-${id}`, domainName, lambdaFunction, } = props;
        const defaultDomainMapping = domainName ? { domainName } : undefined;
        const defaultIntegration = new aws_cdk_lib_1.aws_apigatewayv2_integrations.HttpLambdaIntegration("integration", lambdaFunction, domainName
            ? {
                parameterMapping: new aws_cdk_lib_1.aws_apigatewayv2.ParameterMapping().overwriteHeader("host", aws_cdk_lib_1.aws_apigatewayv2.MappingValue.custom(domainName.name)),
            }
            : undefined);
        this.api = new aws_cdk_lib_1.aws_apigatewayv2.HttpApi(this, "api", {
            apiName,
            defaultDomainMapping,
            defaultIntegration: defaultIntegration,
        });
    }
}
exports.LambdaApiGateway = LambdaApiGateway;
_a = JSII_RTTI_SYMBOL_1;
LambdaApiGateway[_a] = { fqn: "eoapi-cdk.LambdaApiGateway", version: "10.2.1" };
//# sourceMappingURL=data:application/json;base64,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