import { aws_apigatewayv2 as apigatewayv2, aws_ec2 as ec2, aws_lambda as lambda, aws_rds as rds, aws_secretsmanager as secretsmanager } from "aws-cdk-lib";
import { Construct } from "constructs";
import { CustomLambdaFunctionProps } from "../utils";
export declare const EXTENSIONS: {
    readonly QUERY: "query";
    readonly SORT: "sort";
    readonly FIELDS: "fields";
    readonly FILTER: "filter";
    readonly FREE_TEXT: "free_text";
    readonly PAGINATION: "pagination";
    readonly COLLECTION_SEARCH: "collection_search";
    readonly TRANSACTION: "transaction";
    readonly BULK_TRANSACTION: "bulk_transactions";
};
type ExtensionType = (typeof EXTENSIONS)[keyof typeof EXTENSIONS];
export declare class PgStacApiLambdaRuntime extends Construct {
    readonly lambdaFunction: lambda.Function;
    constructor(scope: Construct, id: string, props: PgStacApiLambdaRuntimeProps);
}
export interface PgStacApiLambdaRuntimeProps {
    /**
     * VPC into which the lambda should be deployed.
     */
    readonly vpc?: ec2.IVpc;
    /**
     * RDS Instance with installed pgSTAC or pgbouncer server.
     */
    readonly db: rds.IDatabaseInstance | ec2.IInstance;
    /**
     * Subnet into which the lambda should be deployed.
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * Secret containing connection information for pgSTAC database.
     */
    readonly dbSecret: secretsmanager.ISecret;
    /**
     * Customized environment variables to send to fastapi-pgstac runtime.
     */
    readonly apiEnv?: Record<string, string>;
    /**
     * List of STAC API extensions to enable.
     *
     * @default - query, sort, fields, filter, free_text, pagination, collection_search
     */
    readonly enabledExtensions?: ExtensionType[];
    /**
     * Can be used to override the default lambda function properties.
     *
     * @default - defined in the construct.
     */
    readonly lambdaFunctionOptions?: CustomLambdaFunctionProps;
}
export declare class PgStacApiLambda extends Construct {
    /**
     * URL for the STAC API.
     */
    readonly url: string;
    /**
     * Lambda function for the STAC API.
     */
    readonly lambdaFunction: lambda.Function;
    /**
     * @deprecated - use lambdaFunction instead
     */
    stacApiLambdaFunction: lambda.Function;
    constructor(scope: Construct, id: string, props: PgStacApiLambdaProps);
}
export interface PgStacApiLambdaProps extends PgStacApiLambdaRuntimeProps {
    /**
     * Domain Name for the STAC API. If defined, will create the domain name and integrate it with the STAC API.
     *
     * @default - undefined
     */
    readonly domainName?: apigatewayv2.IDomainName;
    /**
     * Custom Domain Name Options for STAC API.
     *
     * @deprecated Use 'domainName' instead.
     * @default - undefined.
     */
    readonly stacApiDomainName?: apigatewayv2.IDomainName;
}
export {};
