"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PgStacApiLambda = exports.PgStacApiLambdaRuntime = exports.EXTENSIONS = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const path = require("path");
const lambda_api_gateway_1 = require("../lambda-api-gateway");
exports.EXTENSIONS = {
    QUERY: "query",
    SORT: "sort",
    FIELDS: "fields",
    FILTER: "filter",
    FREE_TEXT: "free_text",
    PAGINATION: "pagination",
    COLLECTION_SEARCH: "collection_search",
    TRANSACTION: "transaction",
    BULK_TRANSACTION: "bulk_transactions",
};
/**
 * Validates if a given string is a valid STAC extension
 */
function isValidExtension(value) {
    return Object.values(exports.EXTENSIONS).includes(value);
}
class PgStacApiLambdaRuntime extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const defaultExtensions = [
            exports.EXTENSIONS.QUERY,
            exports.EXTENSIONS.SORT,
            exports.EXTENSIONS.FIELDS,
            exports.EXTENSIONS.FILTER,
            exports.EXTENSIONS.FREE_TEXT,
            exports.EXTENSIONS.PAGINATION,
            exports.EXTENSIONS.COLLECTION_SEARCH,
        ];
        if (props.enabledExtensions) {
            for (const ext of props.enabledExtensions) {
                if (!isValidExtension(ext)) {
                    throw new Error(`Invalid extension: "${ext}". Must be one of: ${Object.values(exports.EXTENSIONS).join(", ")}`);
                }
            }
        }
        const enabledExtensions = props.enabledExtensions || defaultExtensions;
        this.lambdaFunction = new aws_cdk_lib_1.aws_lambda.Function(this, "lambda", {
            // defaults
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_12,
            handler: "handler.handler",
            memorySize: 8192,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_WEEK,
            timeout: aws_cdk_lib_1.Duration.seconds(30),
            code: aws_cdk_lib_1.aws_lambda.Code.fromDockerBuild(path.join(__dirname, ".."), {
                file: "stac-api/runtime/Dockerfile",
                buildArgs: { PYTHON_VERSION: "3.12" },
            }),
            vpc: props.vpc,
            vpcSubnets: props.subnetSelection,
            allowPublicSubnet: true,
            environment: {
                PGSTAC_SECRET_ARN: props.dbSecret.secretArn,
                DB_MIN_CONN_SIZE: "0",
                DB_MAX_CONN_SIZE: "1",
                ENABLED_EXTENSIONS: enabledExtensions.join(","),
                ...props.apiEnv,
            },
            // overwrites defaults with user-provided configurable properties
            ...props.lambdaFunctionOptions,
        });
        props.dbSecret.grantRead(this.lambdaFunction);
        if (props.vpc) {
            this.lambdaFunction.connections.allowTo(props.db, aws_cdk_lib_1.aws_ec2.Port.tcp(5432), "allow connections from stac-fastapi-pgstac");
        }
    }
}
exports.PgStacApiLambdaRuntime = PgStacApiLambdaRuntime;
_a = JSII_RTTI_SYMBOL_1;
PgStacApiLambdaRuntime[_a] = { fqn: "eoapi-cdk.PgStacApiLambdaRuntime", version: "10.2.1" };
class PgStacApiLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const runtime = new PgStacApiLambdaRuntime(this, "runtime", {
            vpc: props.vpc,
            subnetSelection: props.subnetSelection,
            db: props.db,
            dbSecret: props.dbSecret,
            enabledExtensions: props.enabledExtensions,
            apiEnv: props.apiEnv,
            lambdaFunctionOptions: props.lambdaFunctionOptions,
        });
        this.stacApiLambdaFunction = this.lambdaFunction = runtime.lambdaFunction;
        const { api } = new lambda_api_gateway_1.LambdaApiGateway(this, "stac-api", {
            lambdaFunction: runtime.lambdaFunction,
            domainName: props.domainName ?? props.stacApiDomainName,
        });
        this.url = api.url;
        new aws_cdk_lib_1.CfnOutput(this, "stac-api-output", {
            exportName: `${aws_cdk_lib_1.Stack.of(this).stackName}-url`,
            value: this.url,
        });
    }
}
exports.PgStacApiLambda = PgStacApiLambda;
_b = JSII_RTTI_SYMBOL_1;
PgStacApiLambda[_b] = { fqn: "eoapi-cdk.PgStacApiLambda", version: "10.2.1" };
//# sourceMappingURL=data:application/json;base64,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