import * as ec2 from "aws-cdk-lib/aws-ec2";
import * as lambda from "aws-cdk-lib/aws-lambda";
import * as apigatewayv2 from "aws-cdk-lib/aws-apigatewayv2";
import { Construct } from "constructs";
import { CustomLambdaFunctionProps } from "../utils";
export declare class StacAuthProxyLambdaRuntime extends Construct {
    readonly lambdaFunction: lambda.Function;
    constructor(scope: Construct, id: string, props: StacAuthProxyLambdaRuntimeProps);
}
export interface StacAuthProxyLambdaRuntimeProps {
    /**
     * URL to upstream STAC API.
     */
    readonly upstreamUrl: string;
    /**
     * URL to OIDC Discovery Endpoint.
     */
    readonly oidcDiscoveryUrl: string;
    /**
     * OAuth Client ID for Swagger UI.
     */
    readonly stacApiClientId?: string;
    /**
     * VPC into which the lambda should be deployed.
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Subnet into which the lambda should be deployed.
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * Customized environment variables to send to stac-auth-proxy runtime.
     * https://github.com/developmentseed/stac-auth-proxy/?tab=readme-ov-file#configuration
     */
    readonly apiEnv?: Record<string, string>;
    /**
     * Can be used to override the default lambda function properties.
     *
     * @default - defined in the construct.
     */
    readonly lambdaFunctionOptions?: CustomLambdaFunctionProps;
}
export declare class StacAuthProxyLambda extends Construct {
    /**
     * URL for the STAC API.
     */
    readonly url: string;
    /**
     * Lambda function for the STAC API.
     */
    readonly lambdaFunction: lambda.Function;
    constructor(scope: Construct, id: string, props: StacAuthProxyLambdaProps);
}
export interface StacAuthProxyLambdaProps extends StacAuthProxyLambdaRuntimeProps {
    /**
     * Domain Name for the STAC API. If defined, will create the domain name and integrate it with the STAC API.
     *
     * @default - undefined
     */
    readonly domainName?: apigatewayv2.IDomainName;
}
