"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StacAuthProxyLambda = exports.StacAuthProxyLambdaRuntime = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
const lambda_api_gateway_1 = require("../lambda-api-gateway");
const path = require("path");
class StacAuthProxyLambdaRuntime extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambdaFunction = new lambda.Function(this, "lambda", {
            runtime: lambda.Runtime.PYTHON_3_13,
            handler: "handler.handler",
            memorySize: 8192,
            logRetention: cdk.aws_logs.RetentionDays.ONE_WEEK,
            timeout: cdk.Duration.seconds(30),
            code: lambda.Code.fromDockerBuild(path.join(__dirname, ".."), {
                file: "stac-auth-proxy/runtime/Dockerfile",
                buildArgs: { PYTHON_VERSION: "3.13" },
            }),
            vpc: props.vpc,
            vpcSubnets: props.subnetSelection,
            allowPublicSubnet: true,
            environment: {
                // stac-auth-proxy config
                UPSTREAM_URL: props.upstreamUrl,
                OIDC_DISCOVERY_URL: props.oidcDiscoveryUrl,
                // swagger-ui config
                OPENAPI_SPEC_ENDPOINT: "/api",
                SWAGGER_UI_ENDPOINT: "/api.html",
                SWAGGER_UI_INIT_OAUTH: cdk.Stack.of(this).toJsonString({
                    clientId: props.stacApiClientId,
                    usePkceWithAuthorizationCodeGrant: true,
                }),
                // customized settings
                ...props.apiEnv,
            },
            // overwrites defaults with user-provided configurable properties
            ...props.lambdaFunctionOptions,
        });
    }
}
exports.StacAuthProxyLambdaRuntime = StacAuthProxyLambdaRuntime;
_a = JSII_RTTI_SYMBOL_1;
StacAuthProxyLambdaRuntime[_a] = { fqn: "eoapi-cdk.StacAuthProxyLambdaRuntime", version: "10.2.1" };
class StacAuthProxyLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { domainName, ...runtimeProps } = props;
        const runtime = new StacAuthProxyLambdaRuntime(this, "runtime", runtimeProps);
        this.lambdaFunction = runtime.lambdaFunction;
        const { api } = new lambda_api_gateway_1.LambdaApiGateway(this, "stac-auth-proxy", {
            lambdaFunction: runtime.lambdaFunction,
            domainName,
        });
        this.url = api.url;
        new cdk.CfnOutput(this, "stac-auth-proxy-output", {
            exportName: `${cdk.Stack.of(this).stackName}-stac-auth-proxy-url`,
            value: this.url,
        });
    }
}
exports.StacAuthProxyLambda = StacAuthProxyLambda;
_b = JSII_RTTI_SYMBOL_1;
StacAuthProxyLambda[_b] = { fqn: "eoapi-cdk.StacAuthProxyLambda", version: "10.2.1" };
//# sourceMappingURL=data:application/json;base64,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