import { aws_s3 as s3, aws_s3_deployment as s3_deployment } from "aws-cdk-lib";
import { Construct } from "constructs";
export declare class StacBrowser extends Construct {
    bucket: s3.IBucket;
    bucketDeployment: s3_deployment.BucketDeployment;
    constructor(scope: Construct, id: string, props: StacBrowserProps);
    private buildApp;
}
export interface StacBrowserProps {
    /**
     * Bucket ARN. If specified, the identity used to deploy the stack must have the appropriate permissions to create a deployment for this bucket.
     * In addition, if specified, `cloudFrontDistributionArn` is ignored since the policy of an imported resource can't be modified.
     *
     * @default - No bucket ARN. A new bucket will be created.
     */
    readonly bucketArn?: string;
    /**
     * STAC catalog URL. Overrides the catalog URL in the stac-browser configuration.
     */
    readonly stacCatalogUrl: string;
    /**
     * Path to config file for the STAC browser. If not provided, default configuration in the STAC browser
     * repository is used.
     */
    readonly configFilePath?: string;
    /**
     * Tag of the radiant earth stac-browser repo to use to build the app.
     */
    readonly githubRepoTag: string;
    /**
     * The ARN of the cloudfront distribution that will be added to the bucket policy with read access.
     * If `bucketArn` is specified, this parameter is ignored since the policy of an imported bucket can't be modified.
     *
     * @default - No cloudfront distribution ARN. The bucket policy will not be modified.
     */
    readonly cloudFrontDistributionArn?: string;
    /**
     * The name of the index document (e.g. "index.html") for the website. Enables static website
     * hosting for this bucket.
     *
     * @default - No index document.
     */
    readonly websiteIndexDocument?: string;
    /**
     * Location in the filesystem where to compile the browser code.
     *
     * @default - DEFAULT_CLONE_DIRECTORY
     */
    readonly cloneDirectory?: string;
}
