import { aws_apigatewayv2 as apigatewayv2, aws_ec2 as ec2, aws_lambda as lambda, aws_rds as rds, aws_secretsmanager as secretsmanager } from "aws-cdk-lib";
import { Construct } from "constructs";
import { CustomLambdaFunctionProps } from "../utils";
export declare class TiPgApiLambdaRuntime extends Construct {
    readonly lambdaFunction: lambda.Function;
    constructor(scope: Construct, id: string, props: TiPgApiLambdaRuntimeProps);
}
export interface TiPgApiLambdaRuntimeProps {
    /**
     * VPC into which the lambda should be deployed.
     */
    readonly vpc?: ec2.IVpc;
    /**
     * RDS Instance with installed pgSTAC or pgbouncer server.
     */
    readonly db: rds.IDatabaseInstance | ec2.IInstance;
    /**
     * Subnet into which the lambda should be deployed.
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * Secret containing connection information for pgSTAC database.
     */
    readonly dbSecret: secretsmanager.ISecret;
    /**
     * Customized environment variables to send to titiler-pgstac runtime.
     */
    readonly apiEnv?: Record<string, string>;
    /**
     * Can be used to override the default lambda function properties.
     *
     * @default - defined in the construct.
     */
    readonly lambdaFunctionOptions?: CustomLambdaFunctionProps;
}
export declare class TiPgApiLambda extends Construct {
    /**
     * URL for the TiPg API.
     */
    readonly url: string;
    /**
     * Lambda function for the TiPg API.
     */
    readonly lambdaFunction: lambda.Function;
    /**
     * @deprecated - use lambdaFunction instead
     */
    tiPgLambdaFunction: lambda.Function;
    constructor(scope: Construct, id: string, props: TiPgApiLambdaProps);
}
export interface TiPgApiLambdaProps extends TiPgApiLambdaRuntimeProps {
    /**
     * Domain Name for the TiPg API. If defined, will create the domain name and integrate it with the TiPg API.
     *
     * @default - undefined
     */
    readonly domainName?: apigatewayv2.IDomainName;
    /**
     * Custom Domain Name for tipg API. If defined, will create the
     * domain name and integrate it with the tipg API.
     *
     * @deprecated Use 'domainName' instead.
     * @default - undefined
     */
    readonly tipgApiDomainName?: apigatewayv2.IDomainName;
}
