"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TiPgApiLambda = exports.TiPgApiLambdaRuntime = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const path = require("path");
const lambda_api_gateway_1 = require("../lambda-api-gateway");
class TiPgApiLambdaRuntime extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambdaFunction = new aws_cdk_lib_1.aws_lambda.Function(this, "lambda", {
            // defaults
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_12,
            handler: "handler.handler",
            memorySize: 1024,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_WEEK,
            timeout: aws_cdk_lib_1.Duration.seconds(30),
            code: aws_cdk_lib_1.aws_lambda.Code.fromDockerBuild(path.join(__dirname, ".."), {
                file: "tipg-api/runtime/Dockerfile",
                buildArgs: { PYTHON_VERSION: "3.12" },
            }),
            vpc: props.vpc,
            vpcSubnets: props.subnetSelection,
            allowPublicSubnet: true,
            environment: {
                PGSTAC_SECRET_ARN: props.dbSecret.secretArn,
                DB_MIN_CONN_SIZE: "1",
                DB_MAX_CONN_SIZE: "1",
                ...props.apiEnv,
            },
            // overwrites defaults with user-provided configurable properties
            ...props.lambdaFunctionOptions,
        });
        props.dbSecret.grantRead(this.lambdaFunction);
        if (props.vpc) {
            this.lambdaFunction.connections.allowTo(props.db, aws_cdk_lib_1.aws_ec2.Port.tcp(5432), "allow connections from tipg");
        }
    }
}
exports.TiPgApiLambdaRuntime = TiPgApiLambdaRuntime;
_a = JSII_RTTI_SYMBOL_1;
TiPgApiLambdaRuntime[_a] = { fqn: "eoapi-cdk.TiPgApiLambdaRuntime", version: "10.2.1" };
class TiPgApiLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const runtime = new TiPgApiLambdaRuntime(this, "runtime", {
            vpc: props.vpc,
            subnetSelection: props.subnetSelection,
            db: props.db,
            dbSecret: props.dbSecret,
            apiEnv: props.apiEnv,
            lambdaFunctionOptions: props.lambdaFunctionOptions,
        });
        this.tiPgLambdaFunction = this.lambdaFunction = runtime.lambdaFunction;
        const { api } = new lambda_api_gateway_1.LambdaApiGateway(this, "api", {
            lambdaFunction: runtime.lambdaFunction,
            domainName: props.domainName ?? props.tipgApiDomainName,
        });
        this.url = api.url;
        new aws_cdk_lib_1.CfnOutput(this, "tipg-api-output", {
            exportName: `${aws_cdk_lib_1.Stack.of(this).stackName}-tip-url`,
            value: this.url,
        });
    }
}
exports.TiPgApiLambda = TiPgApiLambda;
_b = JSII_RTTI_SYMBOL_1;
TiPgApiLambda[_b] = { fqn: "eoapi-cdk.TiPgApiLambda", version: "10.2.1" };
//# sourceMappingURL=data:application/json;base64,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